/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util.trie;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.util.trie.NodeFactoryImpl;
import com.atlassian.clover.util.trie.PrefixTree;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathPrefixTree<V>
extends PrefixTree<String, V> {
    private static final String EMPTY_KEY = "";

    public FilePathPrefixTree() {
        super(NodeFactoryImpl.HASH_MAP_BACKED, EMPTY_KEY, null);
    }

    public FilePathPrefixTree(@Nullable V value) {
        super(NodeFactoryImpl.HASH_MAP_BACKED, EMPTY_KEY, value);
    }

    public void add(@NotNull File filePath, @Nullable V value) {
        this.add(new FileKeySequence(filePath), value);
    }

    @Nullable
    public PrefixTree.Node<String, V> find(@NotNull File filePath) {
        return this.find(new FileKeySequence(filePath));
    }

    @NotNull
    public PrefixTree.Node<String, V> findNearest(@NotNull File filePath) {
        return this.findNearest(new FileKeySequence(filePath));
    }

    @Nullable
    public PrefixTree.Node<String, V> findNearestWithValue(@NotNull File filePath) {
        return this.findNearestWithValue(new FileKeySequence(filePath));
    }

    public static class FileKeySequence
    extends PrefixTree.KeySequence<String> {
        public FileKeySequence(@NotNull File file) {
            super(FileKeySequence.filePathToSequence(file));
        }

        @NotNull
        protected static List<String> filePathToSequence(@NotNull File path) {
            ArrayList<String> sequence = Lists.newArrayList();
            StringTokenizer tokenizer = new StringTokenizer(path.getAbsolutePath(), File.separator);
            while (tokenizer.hasMoreTokens()) {
                sequence.add(tokenizer.nextToken());
            }
            return sequence;
        }
    }
}

