/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util.trie;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.reporters.html.PackageInfoExt;
import com.atlassian.clover.util.trie.NodeFactoryImpl;
import com.atlassian.clover.util.trie.PrefixTree;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagePrefixTree
extends PrefixTree<String, PackageInfoExt> {
    private static final String EMPTY_KEY = "";

    public PackagePrefixTree() {
        super(NodeFactoryImpl.TREE_MAP_BACKED, EMPTY_KEY, null);
    }

    public void add(@NotNull String packageName, @Nullable PackageInfoExt value) {
        this.add(new PackageKeySequence(packageName), value);
    }

    public void compressTree() {
        PrefixTree.NodeVisitor<String, PackageInfoExt> nodeCompressor = new PrefixTree.NodeVisitor<String, PackageInfoExt>(){

            @Override
            public PrefixTree.Node<String, PackageInfoExt> visit(@NotNull PrefixTree.Node<String, PackageInfoExt> currentNode, int depth) {
                if (currentNode.children().size() == 1 && currentNode.getValue() == null) {
                    PrefixTree.Node<String, PackageInfoExt> childNode = currentNode.children().values().iterator().next();
                    String mergedKey = (currentNode.getKey().isEmpty() ? PackagePrefixTree.EMPTY_KEY : currentNode.getKey() + ".") + childNode.getKey();
                    PrefixTree.Node<String, PackageInfoExt> mergedNode = PackagePrefixTree.this.nodeFactory.createNode(mergedKey, childNode.getValue());
                    mergedNode.children().putAll(childNode.children());
                    return mergedNode;
                }
                return currentNode;
            }
        };
        this.rootNode = this.compressTree(this.rootNode, nodeCompressor);
    }

    public PrefixTree.Node<String, PackageInfoExt> compressTree(PrefixTree.Node<String, PackageInfoExt> rootNode, PrefixTree.NodeVisitor<String, PackageInfoExt> nodeCompressor) {
        return this.rewriteTree(rootNode, nodeCompressor);
    }

    public static class PackageKeySequence
    extends PrefixTree.KeySequence<String> {
        public PackageKeySequence(@NotNull String packageName) {
            super(PackageKeySequence.packageNameToSequence(packageName));
        }

        @NotNull
        protected static List<String> packageNameToSequence(@NotNull String packageName) {
            ArrayList<String> sequence = Lists.newArrayList();
            StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
            while (tokenizer.hasMoreTokens()) {
                sequence.add(tokenizer.nextToken());
            }
            return sequence;
        }
    }
}

