/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import clover.org.apache.commons.lang3.mutable.MutableLong;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ProgressListener;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.recorder.GlobalCoverageRecordingTranscript;
import com.atlassian.clover.recorder.PerTestRecordingTranscript;
import com.atlassian.clover.recorder.RecordingTranscripts;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.FileInfoVisitor;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.clover.util.collections.Pair;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

public class CoverageDataCollator {
    private Clover2Registry registry;
    private RecordingTranscripts.Filter filter;

    public CoverageDataCollator(Clover2Registry registry) {
        this.registry = registry;
    }

    public CoverageDataCollator(Clover2Registry registry, CoverageDataSpec spec) {
        this.registry = registry;
        this.filter = new RecordingTranscripts.Filter(FileUtils.getCurrentDirIfNull(registry.getRegistryFile().getParentFile()), registry.getRegistryFile().getName(), registry.getVersion() - spec.getSpan(), Long.MAX_VALUE, spec.isDeleteUnusedCoverage(), spec.isLoadPerTestData());
    }

    public CoverageDataCollator copyWithNewRegistry(Clover2Registry registry) {
        CoverageDataCollator collator = new CoverageDataCollator(registry);
        collator.filter = this.filter;
        return collator;
    }

    public CoverageData loadCoverageData(CoverageDataSpec spec, ProgressListener progressListener) throws CloverException {
        return this.loadCoverageData(null, spec, progressListener);
    }

    public CoverageData loadCoverageData(CoverageData coverageData, CoverageDataSpec spec, ProgressListener progressListener) throws CloverException {
        RecordingTranscripts.Filter prevFilter = this.filter;
        RecordingTranscripts.Filter newFilter = this.updateFilter(prevFilter, spec);
        if (newFilter == prevFilter && coverageData != null) {
            coverageData = new CoverageData(this.registry, coverageData, spec);
            Pair<Set<RecordingTranscripts.FileRef>, Set<RecordingTranscripts.FileRef>> newRecordings = newFilter.collectUnseenFilesAnd(prevFilter);
            this.collateRecordingFiles((Collection)newRecordings.first, coverageData, spec);
            if (spec.isLoadPerTestData()) {
                this.collatePerTestRecordings((Collection)newRecordings.second, coverageData, spec, progressListener != null ? progressListener : ProgressListener.NOOP_LISTENER);
            }
        } else {
            newFilter.collectAllFiles();
            coverageData = new CoverageData(this.registry, spec);
            this.collateRecordingFiles(newFilter.getCoverageRecordingFiles(), coverageData, spec);
            if (spec.isLoadPerTestData()) {
                this.collatePerTestRecordings(newFilter.getPerTestRecordingFiles(), coverageData, spec, progressListener != null ? progressListener : ProgressListener.NOOP_LISTENER);
            }
        }
        this.filter = newFilter;
        return coverageData;
    }

    public boolean isOutOfDate() {
        return this.filter == null || this.filter.isOutOfDate();
    }

    private RecordingTranscripts.Filter updateFilter(RecordingTranscripts.Filter prevFilter, CoverageDataSpec spec) {
        long from = this.registry.getVersion() - spec.getSpan();
        long to = Long.MAX_VALUE;
        boolean loadPerTestData = spec.isLoadPerTestData();
        return prevFilter == null || prevFilter.getFrom() != from || prevFilter.getTo() != Long.MAX_VALUE || prevFilter.isLoadPerTestData() != loadPerTestData ? new RecordingTranscripts.Filter(FileUtils.getCurrentDirIfNull(this.registry.getRegistryFile().getParentFile()), this.registry.getRegistryFile().getName(), from, Long.MAX_VALUE, spec.isDeleteUnusedCoverage(), loadPerTestData) : prevFilter;
    }

    private void collateRecordingFiles(Collection<RecordingTranscripts.FileRef> files, CoverageData coverageData, CoverageDataSpec spec) {
        long start = System.currentTimeMillis();
        int numRecordings = 0;
        long tsNewestRecordingUsed = 0L;
        long tsOldestRecordingUsed = Long.MAX_VALUE;
        final MutableLong maxVersion = new MutableLong(0L);
        final MutableLong minVersion = new MutableLong(Long.MAX_VALUE);
        this.registry.getProject().visitFiles(new FileInfoVisitor(){

            @Override
            public void visitFileInfo(BaseFileInfo f) {
                FullFileInfo file = (FullFileInfo)f;
                maxVersion.setValue(Math.max(maxVersion.longValue(), file.getMaxVersion()));
                minVersion.setValue(Math.min(minVersion.longValue(), file.getMinVersion()));
            }
        });
        this.logSourceFileTimeStamps(minVersion.longValue(), maxVersion.longValue());
        this.logInstrumentationSessionVersions();
        for (RecordingTranscripts.FileRef recordingFile : files) {
            boolean[] alreadyTruncated = new boolean[]{false};
            try {
                GlobalCoverageRecordingTranscript rec = (GlobalCoverageRecordingTranscript)recordingFile.read(spec);
                long version = rec.getDbVersion();
                this.logGlobalRecordingFileVersion(recordingFile, rec);
                if (version <= maxVersion.longValue() && version >= minVersion.longValue()) {
                    coverageData.addCoverage(rec);
                    ++numRecordings;
                    if (recordingFile.getTimestamp() < tsOldestRecordingUsed) {
                        tsOldestRecordingUsed = recordingFile.getTimestamp();
                    }
                    if (rec.getWriteTimeStamp() <= tsNewestRecordingUsed) continue;
                    tsNewestRecordingUsed = rec.getWriteTimeStamp();
                    continue;
                }
                Logger.getInstance().verbose("Ignoring coverage recording " + rec + " because no FileInfo supports its coverage range");
            }
            catch (IOException e) {
                Logger.getInstance().warn("Failed to load coverage recording " + recordingFile, e);
            }
        }
        coverageData.avoidObviousOverflow();
        coverageData.setTimestamp(tsNewestRecordingUsed);
        long end = System.currentTimeMillis();
        Logger.getInstance().debug("Processed " + numRecordings + " recording files in " + (end - start) + "ms (" + (numRecordings != 0 ? "" + (end - start) / (long)numRecordings + "ms" : "-") + " per recording)");
    }

    private void collatePerTestRecordings(Collection<RecordingTranscripts.FileRef> perTestRecordings, CoverageData coverageData, CoverageDataSpec spec, ProgressListener progressListener) throws CloverException {
        long start = System.currentTimeMillis();
        int numPerTestRecordings = 0;
        float progress = 0.0f;
        float progressIncrement = perTestRecordings.size() > 0 ? 1.0f / (float)perTestRecordings.size() : 1.0f;
        for (RecordingTranscripts.FileRef recordingFile : perTestRecordings) {
            ++numPerTestRecordings;
            try {
                PerTestRecordingTranscript recording = (PerTestRecordingTranscript)recordingFile.read(spec);
                TestCaseInfo tci = TestCaseInfo.Factory.getInstanceForSlice(recording);
                coverageData.addCoverage(tci, recording);
            }
            catch (Exception e) {
                Logger.getInstance().verbose("Failed to load per-test coverage recording " + recordingFile, e);
            }
            progressListener.handleProgress("Reading per-test data", progress += progressIncrement);
        }
        long end = System.currentTimeMillis();
        Logger.getInstance().debug("Processed " + numPerTestRecordings + " per-test recording files in " + (end - start) + "ms (" + (numPerTestRecordings != 0 ? "" + (end - start) / (long)numPerTestRecordings + "ms" : "-") + " per recording)");
    }

    private void logSourceFileTimeStamps(long minVersion, long maxVersion) {
        Logger.getInstance().verbose("Source files timestamps:");
        Logger.getInstance().verbose("  minVersion=" + minVersion + " (" + new Date(minVersion) + ")\n" + "  maxVersion=" + maxVersion + " (" + new Date(maxVersion) + ")");
    }

    private void logInstrumentationSessionVersions() {
        if (!Logger.canIgnore(3)) {
            String sessionTimestamps = "";
            int i = 0;
            Logger.getInstance().verbose("Instrumentation sessions:");
            for (Object obj : this.registry.getInstrHistory()) {
                Clover2Registry.InstrumentationInfo session = (Clover2Registry.InstrumentationInfo)obj;
                sessionTimestamps = sessionTimestamps + "  " + i + ": version " + session.getVersion() + " (" + new Date(session.getVersion()) + ")\n";
                ++i;
            }
            Logger.getInstance().verbose(sessionTimestamps);
        }
    }

    private void logGlobalRecordingFileVersion(RecordingTranscripts.FileRef recordingFile, GlobalCoverageRecordingTranscript rec) {
        Logger.getInstance().verbose("Global recording file:");
        Logger.getInstance().verbose("  file=" + recordingFile.toString() + "\n  dbVersion=" + rec.getDbVersion() + " (" + new Date(rec.getDbVersion()) + ")" + "\n  writeTimeStamp=" + rec.getWriteTimeStamp() + " (" + new Date(rec.getWriteTimeStamp()) + ")");
    }
}

