/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant;

import clover.com.google.common.base.Joiner;
import com.atlassian.clover.Contract;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.AntFileSetUtils;
import com.atlassian.clover.ant.tasks.AntInstrumentationConfig;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntInstrUtils {
    private static Logger LOG = Logger.getInstance();

    public static String getProp(@NotNull Project project, String key, String defaultValue) {
        Contract.pre(key != null);
        String prop = project.getProperty(key);
        if (prop == null) {
            prop = defaultValue;
        }
        return prop;
    }

    @Nullable
    public static PatternSet calcInstrPatternSet(@NotNull Project project) {
        AntInstrumentationConfig config;
        String includes = AntInstrUtils.getProp(project, "clover.includes", "");
        String excludes = AntInstrUtils.getProp(project, "clover.excludes", "");
        PatternSet instrPatternSet = null;
        if (includes.length() > 0 || excludes.length() > 0) {
            instrPatternSet = new PatternSet();
            if (includes.length() > 0) {
                instrPatternSet.setIncludes(includes);
            } else {
                instrPatternSet.setIncludes("**");
            }
            if (excludes.length() > 0) {
                instrPatternSet.setExcludes(excludes);
            }
        }
        if ((config = AntInstrumentationConfig.getFrom(project)) != null && config.getInstrPattern() != null) {
            if (instrPatternSet != null) {
                LOG.warn("Sub-element <files> of <clover-setup> overrides clover.includes/excludes properties.");
            }
            instrPatternSet = config.getInstrPattern();
        }
        return instrPatternSet;
    }

    @Nullable
    public static List<FileSet> calcInstrFileSets(@NotNull Project project) {
        AntInstrumentationConfig config = AntInstrumentationConfig.getFrom(project);
        return config != null ? config.getInstrFilesets() : null;
    }

    public static File createInstrDir(@Nullable File basedir) throws CloverException {
        File tmpDir;
        try {
            File tempDir = FileUtils.getJavaTempDir();
            if (!tempDir.exists()) {
                throw new CloverException("The java.io.tmpdir directory '" + tempDir + "' does not exist. Please ensure this is created.");
            }
            if (!tempDir.canRead()) {
                throw new CloverException("The java.io.tmpdir directory '" + tempDir + "' can not be read from. Please ensure it has appropriate permissions.");
            }
            if (!tempDir.canWrite()) {
                throw new CloverException("The java.io.tmpdir directory '" + tempDir + "' can not be written to. Please ensure it has appropriate permissions.");
            }
            if (basedir != null) {
                if (!basedir.isDirectory() && !basedir.mkdirs()) {
                    throw new CloverException("Failed to create temp directory '" + basedir + "'");
                }
                tmpDir = File.createTempFile("clover", null, basedir);
            } else {
                tmpDir = File.createTempFile("clover", null);
            }
            tmpDir.delete();
            if (!tmpDir.mkdirs() && !tmpDir.isDirectory()) {
                throw new CloverException("Failed to create temp directory: '" + basedir + "'");
            }
        }
        catch (IOException e) {
            throw new CloverException("Failed to create temp directory: '" + basedir + "'", e);
        }
        return tmpDir;
    }

    public static void cleanUpInstrDir(@Nullable File tmpDir, boolean preserveInstr) {
        if (!preserveInstr && tmpDir != null) {
            FileUtils.deltree(tmpDir);
        }
    }

    public static void sieveSourceForInstrumentation(@NotNull Project project, @Nullable Path srcPath, @Nullable PatternSet instrPatternSet, @Nullable List<FileSet> instrFileSetsList, @NotNull Collection<File> toCompile, @NotNull Collection<File> toCopy, @NotNull Collection<File> toInstrument) {
        if (instrPatternSet != null && srcPath != null) {
            LOG.verbose("<files/> element found in <clover-setup/> - filtering source found in" + Arrays.toString(srcPath.list()));
            AntInstrUtils.sieveSourceByPatternSets(project, srcPath, instrPatternSet, toCompile, toCopy, toInstrument);
        } else if (instrFileSetsList != null) {
            LOG.verbose("<fileset/> element(s) found in <clover-setup/>");
            AntInstrUtils.sieveSourceByDirSets(project, instrFileSetsList, toCompile, toCopy, toInstrument);
        } else {
            LOG.verbose("No <files/> nor <fileset/> elements found in <clover-setup/> - instrumenting all source found.");
            AntInstrUtils.sieveSourceByAddingAll(toCompile, toCopy, toInstrument);
        }
    }

    public static void sieveSourceByPatternSets(@NotNull Project project, @NotNull Path srcPath, @NotNull PatternSet instrPatternSet, @NotNull Collection<File> toCompile, @NotNull Collection<File> toCopy, @NotNull Collection<File> toInstrument) {
        for (String srcDir : srcPath.list()) {
            AntInstrUtils.sieveSrcPath(project, instrPatternSet, toCompile, toCopy, toInstrument, srcDir);
        }
    }

    public static void sieveSourceByDirSets(@NotNull Project project, @NotNull List<FileSet> instrFileSetsList, @NotNull Collection<File> toCompile, @NotNull Collection<File> toCopy, @NotNull Collection<File> toInstrument) {
        for (FileSet fileSet : instrFileSetsList) {
            DirectoryScanner ds = fileSet.getDirectoryScanner(project);
            File baseDir = fileSet.getDir(project);
            LOG.verbose("Filtering source files found in " + baseDir.getAbsolutePath());
            AntFileSetUtils.checkForNonTrimmedPatterns(fileSet, project);
            String[] included = ds.getIncludedFiles();
            if (included.length > 0) {
                for (String anIncluded : included) {
                    File inc = new File(baseDir, anIncluded);
                    LOG.verbose("Found file for instrumentation: " + inc.getAbsolutePath());
                    if (toCompile.contains(inc)) {
                        toInstrument.add(inc);
                        toCopy.remove(inc);
                    } else {
                        LOG.verbose("File " + inc.getAbsolutePath() + " not in original compile list - ignoring");
                    }
                    toCompile.remove(inc);
                }
            } else {
                LOG.verbose("No sources found");
            }
            String[] excluded = ds.getExcludedFiles();
            if (excluded.length > 0) {
                for (String anExcluded : excluded) {
                    File exc = new File(baseDir, anExcluded);
                    LOG.verbose("Found file to exclude from instrumentation: " + exc.getAbsolutePath());
                    if (toCompile.contains(exc)) {
                        toInstrument.remove(exc);
                        toCopy.add(exc);
                    } else {
                        LOG.verbose("File " + exc.getAbsolutePath() + " not in original compile list - ignoring");
                    }
                    toCompile.remove(exc);
                }
                continue;
            }
            LOG.verbose("No sources found");
        }
        if (toCompile.size() > 0) {
            LOG.verbose(toCompile.size() + " file(s) in the compile list were neither included or excluded for Clover instrumentation. Adding to the exclude list:");
            for (File file : toCompile) {
                LOG.verbose(file.getAbsolutePath());
            }
            toCopy.addAll(toCompile);
        }
    }

    public static void sieveSourceByAddingAll(@NotNull Collection<File> toCompile, @NotNull Collection<File> toCopy, @NotNull Collection<File> toInstrument) {
        toCopy.clear();
        toInstrument.addAll(toCompile);
    }

    public static void sieveSrcPath(@NotNull Project project, @NotNull PatternSet instrPatternSet, @NotNull Collection<File> toCompile, @NotNull Collection<File> toCopy, @NotNull Collection<File> toInstrument, @NotNull String srcDir) {
        Object[] includePatterns = instrPatternSet.getIncludePatterns(project);
        Object[] excludePatterns = instrPatternSet.getExcludePatterns(project);
        AntFileSetUtils.checkForNonTrimmedPatterns((String[])includePatterns, (String[])excludePatterns, srcDir);
        String message = "Filtering source files in: " + srcDir;
        if (includePatterns != null) {
            message = message + " include patterns: " + Joiner.on(",").join(includePatterns);
        }
        if (excludePatterns != null) {
            message = message + " exclude patterns: " + Joiner.on(",").join(excludePatterns);
        }
        LOG.verbose(message);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(srcDir);
        ds.setIncludes((String[])includePatterns);
        ds.setExcludes((String[])excludePatterns);
        ds.scan();
        for (String anIncluded : ds.getIncludedFiles()) {
            File inc = new File(srcDir, anIncluded);
            if (!toCompile.contains(inc)) continue;
            toInstrument.add(inc);
            toCopy.remove(inc);
        }
        for (String anExcluded : ds.getExcludedFiles()) {
            File exc = new File(srcDir, anExcluded);
            if (!toCompile.contains(exc)) continue;
            toInstrument.remove(exc);
            toCopy.add(exc);
        }
        for (File f : toInstrument) {
            LOG.verbose("Found file for instrumentation: " + f.getAbsolutePath());
        }
        for (File f : toCopy) {
            LOG.verbose("Excluding from instrumentation: " + f.getAbsolutePath());
        }
    }
}

