/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import clover.com.google.common.collect.Lists;
import clover.com.google.common.collect.Sets;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CodeType;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.ant.tasks.AbstractCloverTask;
import com.atlassian.clover.ant.tasks.AntPath;
import com.atlassian.clover.ant.tasks.FilesetFileVisitor;
import com.atlassian.clover.ant.tasks.FilesetFilter;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.recorder.PerTestCoverageStrategy;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.reporters.console.ConsoleReporter;
import com.atlassian.clover.reporters.console.ConsoleReporterConfig;
import com.atlassian.clover.reporters.filters.FileSetFilter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class CloverLogTask
extends AbstractCloverTask {
    private String filterSpec;
    private Level level;
    private List<Package> packages = Lists.newArrayList();
    private Interval span = Interval.DEFAULT_SPAN;
    private Path sourcepath;
    private List<FileSet> testSources = Lists.newArrayList();
    private CodeType codeType = CodeType.APPLICATION;
    private String outputProperty;
    private List<FileSet> filesets = Lists.newArrayList();
    private boolean showUnitTests = false;

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void addPackage(Package packageInfo) {
        this.packages.add(packageInfo);
    }

    public void addSourcepath(Path path) {
        if (this.sourcepath == null) {
            this.sourcepath = path;
        } else {
            this.sourcepath.append(path);
        }
    }

    public void addTestSources(FileSet fileset) {
        this.testSources.add(fileset);
    }

    public void setCodeType(String codeTypeAsString) {
        try {
            this.codeType = CodeType.valueOf(codeTypeAsString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            this.codeType = null;
        }
    }

    public void setFilter(String filterSpec) {
        this.filterSpec = filterSpec;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setOutputProperty(String outputProperty) {
        this.outputProperty = outputProperty;
    }

    public void setShowUnitTests(boolean show) {
        this.showUnitTests = show;
    }

    public void setSpan(Interval span) {
        this.span = span;
    }

    @Override
    public void cloverExecute() {
        String initString = this.resolveInitString();
        ConsoleReporterConfig config = new ConsoleReporterConfig();
        config.setInitString(initString);
        if (this.level != null) {
            config.setLevel(this.level.getValue());
        } else {
            config.setLevel("summary");
        }
        if (!config.validate()) {
            throw new BuildException("configuration is not valid");
        }
        if (this.packages.size() != 0) {
            HashSet<String> packageSet = Sets.newHashSet();
            for (Package packageInfo : this.packages) {
                packageSet.add(packageInfo.packageName);
            }
            config.setPackageSet(packageSet);
        }
        config.setCodeType(this.codeType);
        config.setShowUnitTests(this.showUnitTests);
        try {
            HasMetricsFilter filter = this.filesets.size() != 0 ? new FilesetFilter(this.getProject(), this.filesets) : HasMetricsFilter.ACCEPT_ALL;
            CloverDatabase db = new CloverDatabase(initString, filter, this.getProject().getName(), this.filterSpec);
            final HashSet testFiles = Sets.newHashSet();
            FilesetFileVisitor.Util.collectFiles(this.getProject(), this.testSources, new FilesetFileVisitor(){

                @Override
                public void visit(File file) {
                    testFiles.add(file);
                }
            });
            db.loadCoverageData(new CoverageDataSpec(new FileSetFilter(Lists.newArrayList(testFiles)), this.span.getValueInMillis(), false, true, false, false, PerTestCoverageStrategy.IN_MEMORY));
            if (this.sourcepath != null) {
                db.resolve(new AntPath(this.sourcepath));
            }
            ConsoleReporter reporter = new ConsoleReporter(config);
            if (this.outputProperty != null) {
                StringWriter out = new StringWriter();
                reporter.report(new PrintWriter(out), db);
                this.getProject().setProperty(this.outputProperty, ((Object)out).toString());
            } else {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new LogOutputStream((Task)this, 2));
                reporter.report(new PrintWriter(out), db);
                ((Writer)out).flush();
            }
        }
        catch (CloverException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static class Package {
        private String packageName;

        public void setName(String packageName) {
            this.packageName = packageName;
        }
    }

    public static class Level
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"summary", "package", "class", "method", "statement"};

        public String[] getValues() {
            return VALUES;
        }
    }
}

