/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.types;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.types.BaseCloverOptimizedType;
import com.atlassian.clover.ant.types.CloverAlwaysRunTestSet;
import com.atlassian.clover.ant.types.TestResource;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;

public class CloverOptimizedTestSet
extends BaseCloverOptimizedType
implements ResourceCollection {
    private List<ResourceCollection> resourceCollections;
    private List<Resource> optimizedTestResources;
    private CloverAlwaysRunTestSet alwaysRun;

    public void setOrdering(TestOrdering ordering) {
        ordering.applyTo(this.optionsBuilder);
    }

    public void setMinimize(boolean minimize) {
        this.optionsBuilder.minimize(minimize);
    }

    @Override
    public void setDebug(boolean debug) {
        this.optionsBuilder.debug(debug);
    }

    public void add(CloverAlwaysRunTestSet alwaysRun) {
        this.alwaysRun = alwaysRun;
    }

    public void add(ResourceCollection collection) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.getResourceCollections().add(collection);
    }

    public Iterator iterator() {
        if (this.isReference()) {
            return this.getRef().iterator();
        }
        return this.getOptimizedTestResource().iterator();
    }

    /*
     * Exception decompiling
     */
    private List<Resource> optimizeTestResources() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Resource> toResources(final List<TestResource> testables) {
        return new LinkedList(){
            {
                for (TestResource testResource : testables) {
                    this.add(testResource.getResource());
                }
            }
        };
    }

    private List<TestResource> toTestables(final List<Resource> testables) {
        return new LinkedList(){
            {
                for (Resource resource : testables) {
                    this.add(new TestResource(resource));
                }
            }
        };
    }

    private List<Resource> getUnderlyingResources() {
        OptimizationOptions options;
        LinkedList<Resource> resources = Lists.newLinkedList();
        for (ResourceCollection resourceCollection : this.getResourceCollections()) {
            for (Resource resource : resourceCollection) {
                resources.add(resource);
            }
        }
        if (this.alwaysRun != null) {
            resources.addAll(this.alwaysRun.getGatheredResources());
        }
        if ((options = this.optionsBuilder.build()).isEnabled() && options.isReorderRandomly()) {
            Logger.getInstance().verbose("Randomly shuffling underlying test resources");
            Collections.shuffle(resources);
        }
        return resources;
    }

    public int size() {
        if (this.isReference()) {
            return this.getRef().size();
        }
        return this.getOptimizedTestResource().size();
    }

    public boolean isFilesystemOnly() {
        if (this.isReference()) {
            return this.getRef().isFilesystemOnly();
        }
        boolean filesystemOnly = true;
        for (ResourceCollection resource : this.getResourceCollections()) {
            filesystemOnly = filesystemOnly && resource.isFilesystemOnly();
        }
        return filesystemOnly && (this.alwaysRun == null || this.alwaysRun.isFilesystemOnly());
    }

    private CloverOptimizedTestSet getRef() {
        return (CloverOptimizedTestSet)((Object)this.getCheckedRef(this.getProject()));
    }

    public List<Resource> getOptimizedTestResource() {
        if (this.optimizedTestResources == null) {
            this.optimizedTestResources = this.optimizeTestResources();
        }
        return this.optimizedTestResources;
    }

    private List<ResourceCollection> getResourceCollections() {
        if (this.resourceCollections == null) {
            this.resourceCollections = Lists.newLinkedList();
        }
        return this.resourceCollections;
    }

    public static class TestOrdering
    extends EnumeratedAttribute {
        public static final String FAILFAST = "failfast";
        public static final String ORIGINAL = "original";
        public static final String RANDOM = "random";

        public TestOrdering() {
        }

        public TestOrdering(String value) {
            this.setValue(value);
        }

        public String[] getValues() {
            return new String[]{FAILFAST, ORIGINAL, RANDOM};
        }

        public OptimizationOptions.Builder applyTo(OptimizationOptions.Builder options) {
            if (FAILFAST.equals(this.getValue())) {
                return options.reorderFailfast();
            }
            if (RANDOM.equals(this.getValue())) {
                return options.reorderRandomly();
            }
            return options.dontReorder();
        }
    }
}

