/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import clover.com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class RewriteLambdaToBlockMatcher {
    private static final Set<String> TO_REWRITE_CALLEE_METHODS = ((ImmutableSet.Builder)new ImmutableSet.Builder().add(new String[]{"min", "map", "generate", "iterate", "reduce", "max", "concat", "peek", "filter", "flatMap", "collect", "transform", "compose", "from", "transformValues", "thenApply", "thenCompose"})).build();

    public static boolean shouldRewriteAsBlock(Deque<Deque<String>> currentStack) {
        ArrayDeque<Deque<String>> stack = new ArrayDeque<Deque<String>>(currentStack);
        return !stack.isEmpty() && RewriteLambdaToBlockMatcher.isCalleeMethodOnStack(stack);
    }

    private static boolean isCalleeMethodOnStack(ArrayDeque<Deque<String>> stack) {
        stack.pop();
        if (stack.isEmpty()) {
            return false;
        }
        Deque<String> lambdaCallStack = stack.pop();
        if (lambdaCallStack.isEmpty()) {
            return false;
        }
        String callee = lambdaCallStack.pop();
        return TO_REWRITE_CALLEE_METHODS.contains(callee);
    }
}

