/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.instr.tests.BooleanStrategy;
import com.atlassian.clover.instr.tests.TestDetector;
import java.util.List;

public class AggregateTestDetector
implements TestDetector {
    private final List<TestDetector> detectors = Lists.newArrayList();
    private final BooleanStrategy strategy;

    public AggregateTestDetector(BooleanStrategy strategy) {
        this.strategy = strategy;
    }

    public void addDetector(TestDetector detector) {
        this.detectors.add(detector);
    }

    public boolean isEmpty() {
        return this.detectors.isEmpty();
    }

    @Override
    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        boolean[] values = new boolean[this.detectors.size()];
        for (int i = 0; i < this.detectors.size(); ++i) {
            TestDetector detector = this.detectors.get(i);
            values[i] = detector.isTypeMatch(sourceContext, typeContext);
        }
        return this.strategy.process(values);
    }

    @Override
    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        boolean[] values = new boolean[this.detectors.size()];
        for (int i = 0; i < this.detectors.size(); ++i) {
            TestDetector detector = this.detectors.get(i);
            values[i] = detector.isMethodMatch(sourceContext, methodContext);
        }
        return this.strategy.process(values);
    }
}

