/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests;

import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.util.FilterUtils;
import java.io.File;

public class AntPatternTestDetectorFilter
implements TestDetector {
    final String[] includeFilter;
    final String[] excludeFilter;
    private final String projectRoot;

    public AntPatternTestDetectorFilter(String projectRoot, String[] includeFilter, String[] excludeFilter) {
        this.includeFilter = includeFilter;
        this.excludeFilter = excludeFilter;
        this.projectRoot = projectRoot.endsWith(File.separator) ? projectRoot : projectRoot + File.separator;
    }

    @Override
    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        return this.matchesPattern(sourceContext.getSourceFile());
    }

    @Override
    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        return this.matchesPattern(sourceContext.getSourceFile());
    }

    private boolean matchesPattern(File file) {
        String path = file.getPath();
        String relative = path.startsWith(this.projectRoot) ? path.substring(this.projectRoot.length()) : path;
        return FilterUtils.isIncluded(relative, this.excludeFilter, this.includeFilter, false);
    }
}

