/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests.naming;

import com.atlassian.clover.api.registry.Annotation;
import com.atlassian.clover.api.registry.AnnotationValue;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.ModifiersInfo;
import com.atlassian.clover.instr.tests.naming.TestNameExtractor;
import com.atlassian.clover.registry.entities.StringifiedAnnotationValue;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitParameterizedTestExtractor
implements TestNameExtractor {
    private static final String FQN_PARAMETERIZED_CLASS = "org.junit.runners.Parameterized.class";
    private static final String PARAMETERIZED_CLASS = "Parameterized.class";
    private static final String RUN_WITH = "RunWith";

    @Override
    @Nullable
    public String getTestNameForMethod(@NotNull MethodInfo methodInfo) {
        MethodInfo dataMethod;
        ClassInfo thisClass = methodInfo.getContainingClass();
        if (thisClass != null && JUnitParameterizedTestExtractor.isParameterizedClass(thisClass.getModifiers()) && (dataMethod = JUnitParameterizedTestExtractor.findDataMethod(thisClass)) != null) {
            return JUnitParameterizedTestExtractor.getParametersNameValue(dataMethod);
        }
        return null;
    }

    public static boolean isParameterizedClass(ModifiersInfo modifiers) {
        for (Annotation annotation : modifiers.getAnnotation(RUN_WITH)) {
            String className = JUnitParameterizedTestExtractor.getDefaultValue(annotation);
            if (className == null || !FQN_PARAMETERIZED_CLASS.equals(className) && !PARAMETERIZED_CLASS.equals(className)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static MethodInfo findDataMethod(ClassInfo classInfo) {
        for (MethodInfo methodInfo : classInfo.getMethods()) {
            int mask = methodInfo.getSignature().getModifiers().getMask();
            if (!methodInfo.getSimpleName().equals("data") || (mask & 1) == 0 || (mask & 8) == 0) continue;
            return methodInfo;
        }
        return null;
    }

    @Nullable
    private static String getDefaultValue(Annotation annotation) {
        AnnotationValue defaultValue = annotation.getAttribute("value");
        if (defaultValue instanceof StringifiedAnnotationValue) {
            return ((StringifiedAnnotationValue)defaultValue).getValue();
        }
        return null;
    }

    @Nullable
    private static String getParametersNameValue(MethodInfo dataMethod) {
        Annotation parameters;
        AnnotationValue nameValue;
        Collection<Annotation> parametersAnno = dataMethod.getSignature().getModifiers().getAnnotation("Parameters");
        if (!parametersAnno.isEmpty() && (nameValue = (parameters = parametersAnno.iterator().next()).getAttribute("name")) instanceof StringifiedAnnotationValue) {
            return ((StringifiedAnnotationValue)nameValue).getValue();
        }
        return null;
    }
}

