/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import clover.com.google.common.collect.Sets;
import com.atlassian.clover.recorder.PerTestCoverage;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public abstract class BasePerTestCoverage
implements PerTestCoverage,
Serializable {
    private static final long serialVersionUID = 8596722259646445122L;
    protected final int coverageSize;
    protected transient BitSet uniqueCoverageMask;

    public BasePerTestCoverage(int coverageSize) {
        this.coverageSize = coverageSize;
    }

    @Override
    public int getCoverageSize() {
        return this.coverageSize;
    }

    protected BitSet getUniqueCoverageMask() {
        if (this.uniqueCoverageMask == null) {
            this.initMasks();
        }
        return this.uniqueCoverageMask;
    }

    protected abstract void initMasks();

    @Override
    public BitSet getUniqueHitsFor(TestCaseInfo tci) {
        BitSet hits = this.getHitsFor(tci);
        hits = (BitSet)hits.clone();
        hits.and(this.getUniqueCoverageMask());
        return hits;
    }

    @Override
    public BitSet getUniqueHitsFor(Set<TestCaseInfo> slices) {
        if (slices.size() == 1) {
            return this.getUniqueHitsFor(slices.iterator().next());
        }
        BitSet coverage = this.getHitsFor(slices, null);
        HashSet<TestCaseInfo> otherSlices = Sets.newHashSet(this.getTests());
        otherSlices.removeAll(slices);
        BitSet otherCoverage = this.getHitsFor(otherSlices, null);
        coverage.andNot(otherCoverage);
        return coverage;
    }
}

