/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import clover.com.google.common.collect.Maps;
import clover.com.google.common.collect.Sets;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.Logger;
import com.atlassian.clover.recorder.BaseCoverageRecording;
import com.atlassian.clover.recorder.CoverageRecording;
import com.atlassian.clover.recorder.GlobalCoverageRecordingTranscript;
import com.atlassian.clover.recorder.PerTestRecordingTranscript;
import com.atlassian.clover.util.IOStreamUtils;
import com.atlassian.clover.util.collections.Pair;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RecordingTranscripts {
    public static final String NUM_R36 = "([0-9a-z]+)";
    public static final String STD_REC_SUFFIX = "([0-9a-z]+)_([0-9a-z]+)";
    public static final String SLICE_SUFFIX = "([0-9a-z]+)_([0-9a-z]+)_([0-9a-z]+)_([0-9a-z]+).s";
    public static Pattern stdRecordingSuffix = Pattern.compile("([0-9a-z]+)_([0-9a-z]+)");
    public static Pattern sliceRecordingSuffix = Pattern.compile("([0-9a-z]+)_([0-9a-z]+)_([0-9a-z]+)_([0-9a-z]+).s");

    public static GlobalCoverageRecordingTranscript readCoverageFromDisk(File file, CoverageDataSpec spec) throws IOException {
        return RecordingTranscripts.readCoverageFromDisk(file.getParentFile(), file.getName(), spec);
    }

    /*
     * Exception decompiling
     */
    public static GlobalCoverageRecordingTranscript readCoverageFromDisk(File dir, String file, CoverageDataSpec spec) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static PerTestRecordingTranscript readSliceFromDisk(File dir, String file, CoverageDataSpec spec) throws IOException {
        PerTestRecordingTranscript perTestRecordingTranscript;
        File inf = new File(dir, file);
        DataInputStream in = null;
        try {
            in = new DataInputStream(IOStreamUtils.createInflaterInputStream(inf));
            BaseCoverageRecording.Header header = new BaseCoverageRecording.Header(in);
            Logger.getInstance().debug("Read header for \"" + inf + "\": " + header);
            PerTestRecordingTranscript rec = new PerTestRecordingTranscript(header, inf);
            rec.read(in, spec);
            Logger.getInstance().debug("Recording data for file \"" + inf + "\": " + rec);
            perTestRecordingTranscript = rec;
        }
        catch (IOException e) {
            try {
                Logger.getInstance().verbose("Error reading \"" + inf + "\": " + e + ", skipped.");
                throw e;
            }
            catch (Throwable throwable) {
                IOStreamUtils.close(in);
                throw throwable;
            }
        }
        IOStreamUtils.close(in);
        return perTestRecordingTranscript;
    }

    public static FileRef fromFile(File dir, String filename, String dbname) {
        int baselength = dbname.length();
        try {
            if (filename.startsWith(dbname) && filename.length() > baselength) {
                int tsMarker = filename.lastIndexOf("_");
                if (tsMarker < baselength || tsMarker == filename.length() - 1 || filename.endsWith(".1")) {
                    return null;
                }
                FileRef recfile = new FileRef();
                String suffix = filename.substring(baselength);
                Matcher m = sliceRecordingSuffix.matcher(suffix);
                recfile.datafile = new File(dir, filename);
                if (m.matches()) {
                    recfile.testRecording = true;
                    recfile.typedTestId = Long.parseLong(m.group(1), 36);
                    recfile.runId = Long.parseLong(m.group(2), 36);
                    recfile.hash = Long.parseLong(m.group(3), 36);
                    recfile.timestamp = Long.parseLong(m.group(4), 36);
                    return recfile;
                }
                m = stdRecordingSuffix.matcher(suffix);
                if (m.matches()) {
                    recfile.hash = Long.parseLong(m.group(1), 36);
                    recfile.timestamp = Long.parseLong(m.group(2), 36);
                    return recfile;
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return null;
    }

    public static final class FileRef
    implements Comparable {
        private boolean testRecording;
        private long typedTestId = -1L;
        private long runId;
        private long hash;
        private long timestamp;
        private File datafile;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FileRef other = (FileRef)object;
            if (this.hash != other.hash) {
                return false;
            }
            if (this.testRecording != other.testRecording) {
                return false;
            }
            if (this.timestamp != other.timestamp) {
                return false;
            }
            if (this.typedTestId != other.typedTestId) {
                return false;
            }
            if (this.runId != other.runId) {
                return false;
            }
            return this.datafile.equals(other.datafile);
        }

        public int hashCode() {
            int result = this.testRecording ? 1 : 0;
            result = 31 * result + (int)(this.typedTestId ^ this.typedTestId >>> 32);
            result = 31 * result + (int)(this.runId ^ this.runId >>> 32);
            result = 31 * result + (int)(this.hash ^ this.hash >>> 32);
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            result = 31 * result + this.datafile.hashCode();
            return result;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return 1;
            }
            FileRef other = (FileRef)object;
            if (this.datafile.compareTo(other.datafile) != 0) {
                return this.datafile.compareTo(other.datafile);
            }
            if (this.timestamp > other.timestamp) {
                return 1;
            }
            if (this.timestamp < other.timestamp) {
                return -1;
            }
            if (this.hash > other.hash) {
                return 1;
            }
            if (this.hash < other.hash) {
                return -1;
            }
            if (this.testRecording != other.testRecording) {
                return this.testRecording ? 1 : -1;
            }
            if (this.typedTestId > other.typedTestId) {
                return 1;
            }
            if (this.typedTestId < other.typedTestId) {
                return -1;
            }
            return 0;
        }

        public CoverageRecording read(CoverageDataSpec spec) throws IOException {
            if (this.testRecording) {
                return RecordingTranscripts.readSliceFromDisk(this.getDatafile().getParentFile(), this.getDatafile().getName(), spec);
            }
            return RecordingTranscripts.readCoverageFromDisk(this.getDatafile().getParentFile(), this.getDatafile().getName(), spec);
        }

        public boolean isTestRecording() {
            return this.testRecording;
        }

        public long getTypedTestId() {
            return this.typedTestId;
        }

        public int getTestId() {
            return (int)this.typedTestId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public File getDatafile() {
            return this.datafile;
        }

        public long getRunId() {
            return this.runId;
        }

        public long getHash() {
            return this.hash;
        }

        public String toString() {
            return "RecordingTranscripts.FileRef[datafile=" + this.datafile + ", testRecording=" + this.testRecording + ", typedTestId=" + this.typedTestId + ", runId=" + this.runId + ", hash=" + this.hash + ", timestamp=" + this.timestamp + ']';
        }
    }

    public static class Filter {
        private final File dir;
        private final String basename;
        private final long from;
        private final long to;
        private final boolean deleteExcluded;
        private final boolean loadPerTestData;
        private final Map<String, FileRef> perTestFiles = Maps.newHashMap();
        private final Map<String, FileRef> recordingFiles = Maps.newHashMap();

        public Filter(File dir, String basename, long from, long to, boolean deleteExcluded, boolean loadPerTestData) {
            this.dir = dir;
            this.basename = basename;
            this.from = from;
            this.to = to;
            this.deleteExcluded = deleteExcluded;
            this.loadPerTestData = loadPerTestData;
        }

        public void collectAllFiles() {
            this.collectUnseenFilesAnd(null);
        }

        public Pair<Set<FileRef>, Set<FileRef>> collectUnseenFilesAnd(Filter orig) {
            final Map<Object, Object> origRecordingFiles = orig == null ? Collections.emptyMap() : orig.recordingFiles;
            final Map<Object, Object> origPerTestFiles = orig == null ? Collections.emptyMap() : orig.perTestFiles;
            final HashMap newRecordingFiles = Maps.newHashMap();
            final HashMap newPerTestFiles = Maps.newHashMap();
            this.dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File d, String name) {
                    FileRef recfile = RecordingTranscripts.fromFile(d, name, Filter.this.basename);
                    if (recfile != null) {
                        String path = recfile.getDatafile().getAbsolutePath();
                        if (recfile.getTimestamp() >= Filter.this.from && recfile.getTimestamp() <= Filter.this.to) {
                            if (recfile.isTestRecording()) {
                                if (Filter.this.loadPerTestData && !origPerTestFiles.containsKey(path)) {
                                    Filter.this.perTestFiles.put(path, recfile);
                                    newPerTestFiles.put(path, recfile);
                                }
                            } else if (!origRecordingFiles.containsKey(path)) {
                                Filter.this.recordingFiles.put(path, recfile);
                                newRecordingFiles.put(path, recfile);
                            }
                            return true;
                        }
                        Logger.getInstance().debug((Filter.this.deleteExcluded ? "deleting" : "ignoring") + " out of date coverage recording file: " + name + ", timestamp " + (Filter.this.to < Long.MAX_VALUE ? "not in range " + Filter.this.from + "-" + Filter.this.to : "< " + Filter.this.from));
                        if (Filter.this.deleteExcluded) {
                            recfile.getDatafile().delete();
                        }
                    }
                    return false;
                }
            });
            this.recordingFiles.putAll(origRecordingFiles);
            this.perTestFiles.putAll(origPerTestFiles);
            return Pair.of(Sets.newHashSet(newRecordingFiles.values()), Sets.newHashSet(newPerTestFiles.values()));
        }

        public Set<FileRef> getPerTestRecordingFiles() {
            return Sets.newHashSet(this.perTestFiles.values());
        }

        public Set<FileRef> getCoverageRecordingFiles() {
            return Sets.newHashSet(this.recordingFiles.values());
        }

        public long getFrom() {
            return this.from;
        }

        public long getTo() {
            return this.to;
        }

        public String getBasename() {
            return this.basename;
        }

        public File getDir() {
            return this.dir;
        }

        public boolean isLoadPerTestData() {
            return this.loadPerTestData;
        }

        public boolean isOutOfDate() {
            Filter latestFilter = new Filter(this.dir, this.basename, this.from, this.to, false, false);
            latestFilter.collectAllFiles();
            return !((Object)this.getCoverageRecordingFiles()).equals(latestFilter.getCoverageRecordingFiles());
        }
    }
}

