/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.ContextSet;
import com.atlassian.clover.api.registry.EntityContainer;
import com.atlassian.clover.api.registry.EntityVisitor;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.ModifiersInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.registry.FixedFileRegion;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.entities.Modifiers;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseClassInfo
extends FixedFileRegion
implements ClassInfo {
    protected String name;
    protected String qualifiedName;
    protected Modifiers modifiers;
    protected boolean typeInterface;
    protected boolean typeEnum;
    protected boolean typeAnnotation;
    protected boolean testClass;
    protected transient BasePackageInfo packageInfo;
    protected transient BlockMetrics rawMetrics;
    protected transient BlockMetrics metrics;
    protected transient ContextSet contextFilter;

    public BaseClassInfo(BasePackageInfo packageInfo, BaseFileInfo containingFile, String name, SourceInfo region, Modifiers modifiers, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        super(containingFile, region);
        this.name = name;
        this.packageInfo = packageInfo;
        this.typeInterface = typeInterface;
        this.typeEnum = typeEnum;
        this.typeAnnotation = typeAnnotation;
        this.qualifiedName = this.calcQualifiedName();
        this.modifiers = modifiers;
    }

    protected BaseClassInfo(String name, String qualifiedName, SourceInfo region, Modifiers modifiers, boolean typeInterface, boolean typeEnum, boolean typeAnnotation, boolean testClass) {
        super(null, region);
        this.name = name;
        this.qualifiedName = qualifiedName;
        this.typeInterface = typeInterface;
        this.typeEnum = typeEnum;
        this.typeAnnotation = typeAnnotation;
        this.testClass = testClass;
        this.modifiers = modifiers;
    }

    private String calcQualifiedName() {
        return this.packageInfo == null ? null : (this.packageInfo.isDefault() ? this.getName() : this.packageInfo.getName() + "." + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null && this.packageInfo != null) {
            this.qualifiedName = this.calcQualifiedName();
        }
        return this.qualifiedName;
    }

    @Override
    public ModifiersInfo getModifiers() {
        return this.modifiers;
    }

    @Override
    @Nullable
    public ClassInfo getContainingClass() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    @Nullable
    public MethodInfo getContainingMethod() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    @Nullable
    public FileInfo getContainingFile() {
        return this.containingFile;
    }

    @Override
    public EntityContainer getParent() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    public PackageInfo getPackage() {
        return this.packageInfo;
    }

    void setPackage(BasePackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public boolean isInterface() {
        return this.typeInterface;
    }

    public boolean isEnum() {
        return this.typeEnum;
    }

    public boolean isAnnotationType() {
        return this.typeAnnotation;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        return this.rawMetrics;
    }

    @Override
    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public boolean isTestClass() {
        return this.testClass;
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getClasses() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getAllClasses() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    @NotNull
    public List<? extends MethodInfo> getMethods() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    @NotNull
    public List<? extends MethodInfo> getAllMethods() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    @NotNull
    public List<? extends StatementInfo> getStatements() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    public ContextSet getContextFilter() {
        return this.getContainingFile().getContextFilter();
    }

    public String toString() {
        return "[" + this.getQualifiedName() + ",test=" + this.isTestClass() + ",if=" + this.isInterface() + ",enum=" + this.isEnum() + ",anno=" + this.isAnnotationType() + "]";
    }

    @Override
    public int getAggregatedComplexity() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    public void setAggregatedComplexity(int aggregatedComplexity) {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    public int getAggregatedStatementCount() {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    public void setAggregatedStatementCount(int aggregatedStatements) {
        throw new UnsupportedOperationException("Use FullClassInfo");
    }

    @Override
    public void visit(EntityVisitor entityVisitor) {
        entityVisitor.visitClass(this);
    }
}

