/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.ContextSet;
import com.atlassian.clover.api.registry.EntityContainer;
import com.atlassian.clover.api.registry.EntityVisitor;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.api.registry.ProjectInfo;
import com.atlassian.clover.registry.CachingInfo;
import com.atlassian.clover.registry.FileInfoVisitor;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.BaseProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.util.CloverUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BasePackageInfo
implements PackageInfo,
CachingInfo {
    protected final String name;
    protected final boolean defaultPkg;
    protected final Map<String, FileInfo> files = new LinkedHashMap<String, FileInfo>();
    protected final String path;
    protected BaseProjectInfo containingProject;
    protected BlockMetrics rawMetrics;
    protected BlockMetrics metrics;
    protected ContextSet contextFilter;
    protected List<? extends ClassInfo> classes;
    protected List<? extends ClassInfo> allClasses;

    public BasePackageInfo(BaseProjectInfo containingProject, String name) {
        this.containingProject = containingProject;
        this.defaultPkg = BasePackageInfo.isDefaultName(name);
        this.name = this.defaultPkg ? "default-pkg" : name;
        this.path = CloverUtils.packageNameToPath(name, this.defaultPkg);
    }

    public static boolean isDefaultName(String name) {
        return name.length() == 0 || name.equals("default-pkg");
    }

    @Override
    public EntityContainer getParent() {
        return new EntityContainer(){

            @Override
            public void visit(EntityVisitor entityVisitor) {
                entityVisitor.visitProject(BasePackageInfo.this.containingProject);
            }
        };
    }

    @Override
    public void visit(EntityVisitor entityVisitor) {
        entityVisitor.visitPackage(this);
    }

    @Override
    public ProjectInfo getContainingProject() {
        return this.containingProject;
    }

    @Override
    public ContextSet getContextFilter() {
        return this.getContainingProject().getContextFilter();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isDefault() {
        return this.defaultPkg;
    }

    @Override
    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Override
    @NotNull
    public List<? extends FileInfo> getFiles() {
        return Lists.newArrayList(this.files.values());
    }

    public void addFile(BaseFileInfo file) {
        file.setContainingPackage(this);
        this.files.put(file.getPackagePath(), file);
    }

    public BaseFileInfo getFile(String packagePath) {
        return (BaseFileInfo)this.files.get(packagePath);
    }

    public BaseFileInfo getFileInPackage(String name) {
        return this.getFile(this.getPath() + name);
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getClasses() {
        if (this.classes == null) {
            this.gatherClassesFromPackage();
        }
        return Lists.newArrayList(this.classes);
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getClassesIncludingSubPackages() {
        List<? extends PackageInfo> packages = this.getContainingProject().getAllPackages();
        LinkedList<? extends ClassInfo> classes = Lists.newLinkedList(this.getClasses());
        for (PackageInfo packageInfo : packages) {
            BasePackageInfo otherPkg = (BasePackageInfo)packageInfo;
            if (!otherPkg.isChildOrDescendantOf(this)) continue;
            classes.addAll(otherPkg.getClasses());
        }
        return classes;
    }

    public List<? extends ClassInfo> getClasses(HasMetricsFilter filter) {
        ArrayList<ClassInfo> filteredClasses = Lists.newArrayList();
        List<? extends ClassInfo> allClasses = this.getClasses();
        for (ClassInfo classInfo : allClasses) {
            if (!filter.accept(classInfo)) continue;
            filteredClasses.add(classInfo);
        }
        return filteredClasses;
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getAllClasses() {
        if (this.allClasses == null) {
            this.gatherAllClassesFromPackage();
        }
        return Lists.newArrayList(this.allClasses);
    }

    @Override
    @NotNull
    public List<? extends ClassInfo> getAllClassesIncludingSubPackages() {
        List<? extends PackageInfo> packages = this.getContainingProject().getAllPackages();
        LinkedList<? extends ClassInfo> classes = Lists.newLinkedList(this.getAllClasses());
        for (PackageInfo packageInfo : packages) {
            BasePackageInfo otherPkg = (BasePackageInfo)packageInfo;
            if (!otherPkg.isChildOrDescendantOf(this)) continue;
            classes.addAll(otherPkg.getAllClasses());
        }
        return classes;
    }

    @Override
    public boolean isDescendantOf(PackageInfo other) {
        throw new UnsupportedOperationException("Use FullPackageInfo");
    }

    @Override
    public BlockMetrics getRawMetrics() {
        return this.rawMetrics;
    }

    @Override
    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    public void visitFiles(FileInfoVisitor visitor) {
        for (FileInfo fileInfo : this.files.values()) {
            visitor.visitFileInfo((BaseFileInfo)fileInfo);
        }
    }

    public boolean isChildOrDescendantOf(BasePackageInfo other) {
        return this.containingProject == other.containingProject && this != other && (other.isDefault() || this.getName().indexOf(other.getName() + ".") == 0);
    }

    public boolean isNamed(String name) {
        return this.isDefault() && BasePackageInfo.isDefaultName(name) || this.name.equals(name);
    }

    @Override
    public void invalidateCaches() {
        this.classes = null;
        this.rawMetrics = null;
        this.metrics = null;
    }

    protected void gatherClassesFromPackage() {
        ArrayList<? extends ClassInfo> topLevelClasses = Lists.newArrayList();
        for (FileInfo file : this.files.values()) {
            topLevelClasses.addAll(file.getClasses());
        }
        this.classes = topLevelClasses;
    }

    protected void gatherAllClassesFromPackage() {
        ArrayList<? extends ClassInfo> tmpClasses = Lists.newArrayList();
        for (FileInfo fileInfo : this.files.values()) {
            tmpClasses.addAll(fileInfo.getAllClasses());
        }
        this.allClasses = tmpClasses;
    }
}

