/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.metrics;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.metrics.FileMetrics;

public class PackageMetrics
extends FileMetrics {
    private int numFiles;

    public PackageMetrics(HasMetrics owner) {
        super(owner);
    }

    @Override
    public String getType() {
        return "package";
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    public void setNumFiles(int numFiles) {
        this.numFiles = numFiles;
    }

    @Override
    public int getNumChildren() {
        return this.getNumFiles();
    }

    @Override
    public String getChildType() {
        return super.getType();
    }

    public float getAvgClassesPerFile() {
        return this.getFraction(this.getNumClasses(), this.numFiles);
    }

    public PackageMetrics add(PackageMetrics metrics) {
        super.add(metrics);
        this.numFiles += metrics.numFiles;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PackageMetrics that = (PackageMetrics)o;
        return this.numFiles == that.numFiles;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.numFiles;
        return result;
    }

    @Override
    public String toString() {
        return "PackageMetrics{numFiles=" + this.numFiles + "} " + super.toString();
    }
}

