/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.Logger;
import com.atlassian.clover.MaskedBitSetCoverageProvider;
import com.atlassian.clover.TestResultProcessor;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.Type;
import com.atlassian.clover.reporters.filters.DefaultTestFilter;
import com.atlassian.clover.reporters.filters.FileSetFilter;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class Current
extends CloverReportConfig {
    private boolean summary;
    protected static final String ERR_INITSTRING_NOT_SPECIFIED = "initstring not specified.";
    public static final Current DEFAULT_HTML = new Current(false);
    public static final Current DEFAULT_XML = new Current(false);
    public static final Current DEFAULT_PDF = new Current(true);
    private int maxTestsPerFile = -1;
    private boolean includeFailedTestCoverage = false;
    private List<File> testSourceFiles = Lists.newArrayList();
    protected List<File> testResultFiles;
    private List<String> globalFileNames = Lists.newArrayList();
    private int numThreads = 2;
    private Interval timeOut = new Interval(9223372036854775L, 0);
    private boolean showUniqueCoverage = false;
    private boolean showLambdaFunctions = false;
    private boolean showInnerFunctions = false;

    public Current() {
    }

    public Current(Current that) {
        this.summary = that.summary;
    }

    public Current(boolean summary) {
        this.summary = summary;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public boolean getSummary() {
        return this.summary;
    }

    @Override
    public boolean validate() {
        Format format;
        if (!super.validate()) {
            return false;
        }
        if (this.getInitString() == null || this.getInitString().length() == 0) {
            this.setFailureReason(ERR_INITSTRING_NOT_SPECIFIED);
            return false;
        }
        if (this.getFormat() == null) {
            if (this.getSummary()) {
                this.setFormat(Format.DEFAULT_PDF);
            } else {
                this.setFormat(Format.DEFAULT_XML);
            }
        }
        if ((format = this.getFormat()) != null) {
            if (format.getType() == null) {
                this.setFailureReason("You need to set the report type");
                return false;
            }
            if (format.in(Type.PDF) && !this.getSummary()) {
                this.setFailureReason("Can only do summary reports in PDF. Use summary=\"true\" option.");
                return false;
            }
            if (format.in(Type.PDF) && (this.isShowInnerFunctions() || this.isShowLambdaFunctions())) {
                this.setFailureReason("The showInnerFunctions and/or showLambdaFunctions are not supported in PDF.");
                return false;
            }
        }
        if (this.numThreads < 0) {
            this.setFailureReason("numThreads must be greater than or equal to zero, not: " + this.numThreads);
            return false;
        }
        return true;
    }

    public String toString() {
        return "Current[" + (Object)((Object)this.getFormat().getType()) + ", " + this.getOutFile().getAbsolutePath() + "]";
    }

    public void addGlobalFileName(String fileName) {
        this.globalFileNames.add(fileName);
    }

    public void addTestResultFile(File file) {
        if (this.testResultFiles == null) {
            this.testResultFiles = Lists.newArrayList();
        }
        this.testResultFiles.add(file);
    }

    public void addTestSourceFile(File file) {
        this.testSourceFiles.add(file);
    }

    public List<File> getTestSourceFiles() {
        return Collections.unmodifiableList(this.testSourceFiles);
    }

    public List<String> getGlobalSourceFileNames() {
        return Collections.unmodifiableList(this.globalFileNames);
    }

    @Override
    public CloverDatabase getCoverageDatabase() throws CloverException {
        boolean hasTestResult;
        this.setLoadTestResults(this.testResultFiles == null);
        CloverDatabase db = super.getCoverageDatabase();
        try {
            if (!this.isLoadTestResults() && db.getTestOnlyModel() != null) {
                TestResultProcessor.addTestResultsToModel(db.getTestOnlyModel(), this.testResultFiles);
            }
        }
        catch (CloverException e) {
            Logger.getInstance().error("Error parsing test results: " + e.getMessage() + " - Test results will not be included.");
        }
        boolean bl = hasTestResult = db.getTestOnlyModel() != null && db.getTestOnlyModel().hasTestResults();
        if (hasTestResult && !this.isIncludeFailedTestCoverage()) {
            CoverageData data = db.getCoverageData();
            MaskedBitSetCoverageProvider provider = new MaskedBitSetCoverageProvider(data.getPassOnlyAndIncidentalHits(), data, data);
            db.getAppOnlyModel().setDataProvider(provider);
            db.getTestOnlyModel().setDataProvider(provider);
            db.getFullModel().setDataProvider(provider);
            db.getFullModel().setHasTestResults(hasTestResult);
        }
        if (this.isIncludeFailedTestCoverage() && !hasTestResult) {
            Logger.getInstance().debug("includeFailedTestCoverage='" + this.isIncludeFailedTestCoverage() + "', however no test results were found.");
        }
        return db;
    }

    @Override
    protected HasMetricsFilter.Invertable effectiveTestFilter() {
        if (this.testSourceFiles.size() > 0) {
            return new FileSetFilter(this.testSourceFiles);
        }
        HasMetricsFilter.Invertable filter = this.getTestFilter();
        return filter != null ? filter : new DefaultTestFilter();
    }

    public int getMaxTestsPerFile() {
        return this.maxTestsPerFile;
    }

    public void setMaxTestsPerFile(int maxTestsPerFile) {
        this.maxTestsPerFile = maxTestsPerFile;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public boolean isShowLambdaFunctions() {
        return this.showLambdaFunctions;
    }

    public void setShowLambdaFunctions(boolean showLambdaFunctions) {
        this.showLambdaFunctions = showLambdaFunctions;
    }

    public boolean isShowInnerFunctions() {
        return this.showInnerFunctions;
    }

    public void setShowInnerFunctions(boolean showInnerFunctions) {
        this.showInnerFunctions = showInnerFunctions;
    }

    public boolean isShowUniqueCoverage() {
        return this.showUniqueCoverage;
    }

    public void setShowUniqueCoverage(boolean showUniqueCoverage) {
        this.showUniqueCoverage = showUniqueCoverage;
    }

    public boolean isIncludeFailedTestCoverage() {
        return this.includeFailedTestCoverage;
    }

    public void setIncludeFailedTestCoverage(boolean includeFailedTestCoverage) {
        this.includeFailedTestCoverage = includeFailedTestCoverage;
    }

    public Interval getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(String timeOutDescription) {
        this.timeOut = new Interval(timeOutDescription);
    }
}

