/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters;

import clover.com.google.common.collect.Lists;
import clover.com.google.common.collect.Maps;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.registry.metrics.HasMetricsSupport;
import com.atlassian.clover.registry.util.EntityVisitorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MetricsCollator {
    final HasMetricsFilter methodFilter = new HasMetricsFilter(){

        @Override
        public boolean accept(HasMetrics hm) {
            return hm.getMetrics().getPcCoveredElements() != 1.0f && hm.getMetrics().getNumElements() > 0;
        }
    };
    final EntityVisitorUtils entityUtils = new EntityVisitorUtils();

    public List<MethodInfo> getLeastTestedMethods(List<? extends ClassInfo> classes, boolean showLambdaFunctions, boolean showInnerFunctions) {
        ArrayList<MethodInfo> methodsLeastTested = Lists.newArrayList();
        int numMethods = 20;
        for (ClassInfo classInfo : classes) {
            for (MethodInfo methodInfo : classInfo.getAllMethods()) {
                if (!this.methodFilter.accept(methodInfo) || !showLambdaFunctions && methodInfo.isLambda() || !showInnerFunctions && this.entityUtils.isInnerMethod(methodInfo)) continue;
                methodsLeastTested.add(methodInfo);
            }
        }
        ArrayList<HasMetricsSupport.HasMetricsComparator> comparators = Lists.newArrayList();
        comparators.add(HasMetricsSupport.CMP_PC_ASC);
        comparators.add(HasMetricsSupport.CMP_ELEMENTS_UNCOVERED_DESC);
        comparators.add(HasMetricsSupport.CMP_COMPLEXITY_DESC);
        HasMetricsSupport.HasMetricsComparatorChain hasMetricsComparatorChain = new HasMetricsSupport.HasMetricsComparatorChain(comparators);
        Collections.sort(methodsLeastTested, hasMetricsComparatorChain);
        int toIndex = methodsLeastTested.size() < numMethods ? methodsLeastTested.size() : numMethods;
        return methodsLeastTested.subList(0, toIndex);
    }

    public List getTopRisks(Map<Integer, List<ClassInfo>> classMap, int risksCount) {
        int count = 0;
        ArrayList<ClassInfo> topRisks = new ArrayList<ClassInfo>(risksCount);
        for (Integer key : classMap.keySet()) {
            List<ClassInfo> list = classMap.get(key);
            int size = list.size();
            if (count + size >= risksCount) {
                int diff = risksCount - count;
                topRisks.addAll(list.subList(0, diff));
                break;
            }
            topRisks.addAll(list);
            count += size;
        }
        return topRisks;
    }

    public Map<Integer, List<ClassInfo>> rankProjectRisks(List<? extends ClassInfo> pceOrder, List amcOrder) {
        TreeMap<Integer, List<ClassInfo>> classMap = Maps.newTreeMap();
        int i = 0;
        for (ClassInfo classInfo : pceOrder) {
            List<ClassInfo> value;
            int rank = amcOrder.indexOf(classInfo) + ++i;
            Integer key = new Integer(rank);
            if (classMap.containsKey(key)) {
                value = (List)classMap.get(key);
            } else {
                value = Lists.newArrayList();
                classMap.put(key, value);
            }
            value.add(classInfo);
        }
        return classMap;
    }

    public List getTopOfList(List infos, int topNCount, HasMetricsSupport.HasMetricsComparator cmp) {
        Collections.sort(infos, cmp);
        Collections.reverse(infos);
        int last = infos.size() >= topNCount ? topNCount : infos.size();
        return infos.subList(0, last);
    }
}

