/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.com.google.common.collect.Lists;
import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.html.ClassInfoStatsCalculator;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.HtmlReporter;
import com.atlassian.clover.reporters.html.StatisticsClassInfoVisitor;
import com.atlassian.clover.reporters.html.TabInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public abstract class RenderCoverageCloudAction
implements Callable {
    protected final List classes;
    protected final File basePath;
    protected final VelocityContext context;
    protected final CloverReportConfig reportConfig;
    protected final HtmlReporter.TreeInfo tree;

    public RenderCoverageCloudAction(VelocityContext context, CloverReportConfig reportConfig, HtmlReporter.TreeInfo tree, List classes, File basePath) {
        this.context = context;
        this.reportConfig = reportConfig;
        this.tree = tree;
        this.classes = classes;
        this.basePath = basePath;
    }

    public Object call() throws Exception {
        ArrayList<TabInfo> allTabs = Lists.newArrayList();
        TabInfo risksInfo = this.createRisksTab();
        TabInfo quickWinsInfo = this.createQuickWinsTab();
        allTabs.add(risksInfo);
        allTabs.add(quickWinsInfo);
        this.renderQuickWins(this.createOutputDir(), allTabs, quickWinsInfo, this.tree);
        this.renderProjectRisks(this.createOutputDir(), allTabs, risksInfo, this.tree);
        return null;
    }

    protected abstract File createOutputDir() throws IOException;

    protected abstract TabInfo createRisksTab();

    protected TabInfo createQuickWinsTab() {
        return new TabInfo("Quick Wins", "quick-wins.html", "help_pkg_quick_wins");
    }

    protected void renderProjectRisks(File outDir, List<TabInfo> allTabs, TabInfo currentTab, HtmlReporter.TreeInfo tree) throws Exception {
        this.renderCloudPage(outDir, allTabs, new ClassInfoStatsCalculator.AvgMethodComplexityCalculator(), new ClassInfoStatsCalculator.PcCoveredElementsCalculator(), currentTab, tree);
    }

    protected void renderQuickWins(File outDir, List<TabInfo> allTabs, TabInfo currentTab, HtmlReporter.TreeInfo tree) throws Exception {
        this.renderCloudPage(outDir, allTabs, new ClassInfoStatsCalculator.ElementCountCalculator(), new ClassInfoStatsCalculator.CoveredElementsCalculator(), currentTab, tree);
    }

    protected void renderCloudPage(File outDir, List<TabInfo> allTabs, ClassInfoStatsCalculator axis1, ClassInfoStatsCalculator axis2, TabInfo currentTab, HtmlReporter.TreeInfo tree) throws Exception {
        this.context.put("currentPageURL", currentTab.getFilename());
        this.context.put("tabs", allTabs);
        this.context.put("tree", tree);
        this.context.put("showCloudOwner", Boolean.TRUE);
        this.applySpecificProperties();
        this.applyAxies(axis1, axis2);
        this.context.put("title", currentTab.getTitle());
        HtmlReportUtil.mergeTemplateToFile(new File(outDir, currentTab.getFilename()), this.context, "cloud-page.vm");
    }

    protected void applyAxis(String prefix, ClassInfoStatsCalculator axis1, ClassInfoStatsCalculator axis2, List classes) {
        StatisticsClassInfoVisitor v2 = StatisticsClassInfoVisitor.visit(classes, axis2);
        StatisticsClassInfoVisitor v1 = StatisticsClassInfoVisitor.visit(v2.getClasses(), axis1);
        this.context.put(prefix + "axis", Boolean.TRUE);
        this.context.put(prefix + "axis1", v1);
        this.context.put(prefix + "axis2", v2);
    }

    protected abstract void applyAxies(ClassInfoStatsCalculator var1, ClassInfoStatsCalculator var2);

    protected abstract void applySpecificProperties();
}

