/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsSupport;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.PackageInfoExt;
import com.atlassian.clover.util.trie.PackagePrefixTree;
import com.atlassian.clover.util.trie.PrefixTree;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public class RenderPackageTreeJsonAction
implements Callable {
    private final FullProjectInfo fullProjectInfo;
    private final FullProjectInfo appProjectInfo;
    private final VelocityContext context;
    private final Current reportConfig;
    private final File basePath;

    public RenderPackageTreeJsonAction(VelocityContext ctx, File basePath, FullProjectInfo fullProjectInfo, FullProjectInfo appProjectInfo, Current reportConfig) {
        this.basePath = basePath;
        this.fullProjectInfo = fullProjectInfo;
        this.appProjectInfo = appProjectInfo;
        this.context = ctx;
        this.reportConfig = reportConfig;
    }

    public Object call() throws Exception {
        File outfile = this.insertPackageTreeProperties();
        HtmlReportUtil.mergeTemplateToFile(outfile, this.context, "package-nodes-tree.vm");
        return null;
    }

    protected File insertPackageTreeProperties() throws Exception {
        PrefixTree<String, PackageInfoExt> packageTree = this.createTreeFromList(this.collectAllPackagesByName());
        this.context.put("projectInfo", this.fullProjectInfo);
        this.context.put("packageTree", packageTree.getRootNode());
        String filename = "package-nodes-tree.js";
        return new File(this.basePath, "package-nodes-tree.js");
    }

    protected List<PackageInfoExt> collectAllPackagesByName() {
        List<? extends PackageInfo> packages = this.fullProjectInfo.getAllPackages();
        Collections.sort(packages, HasMetricsSupport.LEX_COMP);
        ArrayList<PackageInfoExt> packagesExt = new ArrayList<PackageInfoExt>(packages.size());
        for (PackageInfo packageInfo : packages) {
            packagesExt.add(new PackageInfoExt(packageInfo, this.appProjectInfo.findPackage(packageInfo.getName()) == null));
        }
        return packagesExt;
    }

    private PrefixTree<String, PackageInfoExt> createTreeFromList(List<PackageInfoExt> allPackages) {
        PackagePrefixTree trie = new PackagePrefixTree();
        for (PackageInfoExt pkgExt : allPackages) {
            trie.add(pkgExt.getPackageInfo().getName(), pkgExt);
        }
        trie.compressTree();
        return trie;
    }
}

