/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html.source;

import clover.antlr.TokenStreamException;
import clover.com.google.common.collect.Lists;
import clover.org.apache.commons.lang3.StringUtils;
import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.ContextSet;
import com.atlassian.clover.api.registry.ElementInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.LineInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import com.atlassian.clover.reporters.html.JSONObjectFactory;
import com.atlassian.clover.reporters.html.source.SourceRendererManager;
import com.atlassian.clover.spi.reporters.html.source.LineRenderInfo;
import com.atlassian.clover.spi.reporters.html.source.SourceRenderer;
import com.atlassian.clover.util.ChecksummingReader;
import com.atlassian.clover.util.IOStreamUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class SourceRenderHelper {
    private CloverDatabase database;
    private CoverageDataProvider coverageProvider;
    private Current report;
    private HtmlRenderingSupportImpl renderingHelper;
    private boolean outOfDate;
    private final String spaceChar;
    private final String tabStr;

    public SourceRenderHelper(CloverDatabase database, Current report, HtmlRenderingSupportImpl renderingHelper) {
        this.database = database;
        this.coverageProvider = database.getFullModel().getDataProvider();
        this.report = report;
        this.renderingHelper = renderingHelper;
        this.spaceChar = StringUtils.defaultIfEmpty(report.getFormat().getSpaceChar(), " ");
        this.tabStr = StringUtils.repeat(this.spaceChar, report.getFormat().getTabWidth());
    }

    public void insertLineInfosForFile(FullFileInfo fileInfo, VelocityContext context, ContextSet contextSet, String emptyChar, List[] testLineInfo) throws TokenStreamException {
        try {
            LineRenderInfo[] renderInfo = this.gatherSrcRenderInfo(context, fileInfo, contextSet, emptyChar, testLineInfo);
            context.put("renderInfo", renderInfo);
            context.put("jsonSrcFileLines", JSONObjectFactory.getJSONSrcFileLines(renderInfo, fileInfo.getName()));
            if (this.outOfDate) {
                this.addWarning(context, "The source file used to generate this report was changed after Clover generated coverage information. The coverage reported may not match the source lines. You should regenerate the coverage information and the report to ensure the files are in sync.");
                Logger.getInstance().warn("Source file " + fileInfo.getPhysicalFile() + " has changed since coverage information was" + " generated");
            }
        }
        catch (FileNotFoundException e) {
            Logger.getInstance().error(e);
            this.putErrorMessage(context, "Clover could not read the source file \"" + fileInfo.getPhysicalFile().getAbsolutePath() + "\"");
        }
        catch (Exception e) {
            Logger.getInstance().error(e);
            this.putErrorMessage(context, "Clover encountered a problem rendering the source for this file.");
        }
    }

    private void putErrorMessage(VelocityContext context, String message) {
        context.put("errormsg", message);
    }

    private void addWarning(VelocityContext context, String message) {
        ArrayList<String> warningMessages = (ArrayList<String>)context.get("warningMessages");
        if (warningMessages == null) {
            warningMessages = Lists.newArrayList();
        }
        warningMessages.add(message);
        context.put("warningMessages", warningMessages);
    }

    public LineRenderInfo[] gatherSrcRenderInfo(VelocityContext vc, FullFileInfo finfo, ContextSet contextSet, String emptyCoverageChar, List<TestCaseInfo>[] testLineInfo) throws Exception {
        ChecksummingReader csr;
        finfo.setDataProvider(this.coverageProvider);
        int lineCount = finfo.getLineCount();
        ArrayList<LineRenderInfo> renderedLines = new ArrayList<LineRenderInfo>(lineCount);
        try {
            SourceRenderer renderer = SourceRendererManager.getRendererForFileExtension(this.extensionOf(finfo.getName()));
            if (renderer == null) {
                Logger.getInstance().debug("No renderer registered for files with extension \"" + this.extensionOf(finfo.getName()) + "\". Using plaintext renderer for file " + finfo.getName());
                renderer = SourceRendererManager.getPlaintextRenderer();
            } else {
                Logger.getInstance().debug("Found source renderer " + renderer.getClass().getName() + " for file " + finfo.getName());
            }
            csr = this.render(finfo, renderedLines, emptyCoverageChar, renderer);
        }
        catch (Throwable t) {
            Logger.getInstance().error("Failed to render syntax highlights for " + finfo.getPhysicalFile().getAbsolutePath() + ": " + t.getMessage(), t);
            this.putErrorMessage(vc, "Clover encountered a problem rendering the source for this file. Syntax highlighting has been disabled.");
            renderedLines.clear();
            csr = this.render(finfo, renderedLines, emptyCoverageChar, SourceRendererManager.getPlaintextRenderer());
        }
        LineInfo[] lines = finfo.getLineInfo(renderedLines.size() + 1, this.report.isShowLambdaFunctions(), this.report.isShowInnerFunctions());
        for (int i = 0; i < renderedLines.size(); ++i) {
            List<TestCaseInfo> testsForLine;
            LineInfo linfo;
            String ccstr;
            int headlineHits;
            String msg;
            ContextSet filteredCtx;
            boolean hilightBad;
            boolean hilightInfo;
            boolean hasSomeCoverage;
            block26: {
                hasSomeCoverage = false;
                hilightInfo = false;
                hilightBad = false;
                filteredCtx = null;
                msg = "";
                headlineHits = -1;
                ccstr = emptyCoverageChar;
                linfo = lines[i + 1];
                if (linfo != null) {
                    List<FullElementInfo> lineElements = linfo.getColumnOrderedElementInfos();
                    for (FullElementInfo lineElement : lineElements) {
                        if (filteredCtx != null || lineElement.isFiltered(contextSet)) {
                            filteredCtx = lineElement.getContext();
                            break block26;
                        }
                        if (lineElement.getHitCount() <= 0) continue;
                        hasSomeCoverage = true;
                        break;
                    }
                    for (FullElementInfo lineElement : lineElements) {
                        String[] messages;
                        if (this.noHits(lineElement)) {
                            messages = this.calcCoverageMsg(lineElement, emptyCoverageChar);
                            msg = messages[0];
                            ccstr = messages[1];
                            headlineHits = this.hitCounts(lineElement);
                            hilightBad = true;
                            break;
                        }
                        messages = this.calcCoverageMsg(lineElement, emptyCoverageChar);
                        msg = messages[0];
                        ccstr = messages[1];
                        headlineHits = this.hitCounts(lineElement);
                    }
                }
            }
            if (headlineHits >= 0) {
                hilightInfo = true;
                if (ccstr.equals(emptyCoverageChar) && filteredCtx == null) {
                    ccstr = "" + headlineHits;
                }
            }
            if (renderedLines.size() <= i || renderedLines.get(i) == null) {
                renderedLines.add(new LineRenderInfo(emptyCoverageChar));
            }
            LineRenderInfo thisLine = (LineRenderInfo)renderedLines.get(i);
            if (linfo != null && linfo.hasClassStarts()) {
                thisLine.setClassStart(linfo.getClassStarts()[0]);
            }
            if (linfo != null && linfo.hasMethodStarts()) {
                thisLine.setMethodStart(linfo.getMethodStarts()[0]);
            }
            if (linfo != null && linfo.hasFailStackEntries()) {
                thisLine.setFailedStackEntries(linfo.getFailStackEntries());
            }
            boolean classStart = thisLine.getClassStart() != null;
            String hitClass = "missedByTest";
            List<TestCaseInfo> list = testsForLine = testLineInfo == null || i + 1 >= testLineInfo.length ? null : testLineInfo[i + 1];
            if (testsForLine != null) {
                for (TestCaseInfo tci : testsForLine) {
                    if (!tci.isSuccess()) {
                        hitClass = "hitByFailedTest";
                        continue;
                    }
                    hitClass = "hitByTest";
                    break;
                }
            }
            if (filteredCtx != null) {
                thisLine.setLineNumberCSS("lineCount Filtered");
                thisLine.setCoverageCountCSS("coverageCount Filtered");
                thisLine.setTestHitCSS("missedByTest");
                thisLine.setSourceCSS("srcLineFiltered");
                thisLine.setFiltered(true);
                filteredCtx = filteredCtx.and(contextSet);
                String contextString = this.database.getContextStore().getContextsAsString(filteredCtx);
                msg = "Filtered by: " + this.renderingHelper.htmlEscapeStr(contextString);
            } else if (hilightBad) {
                thisLine.setLineNumberCSS("lineCount " + (hasSomeCoverage ? "Good" : "Bad"));
                thisLine.setCoverageCountCSS("coverageCount Bad");
                thisLine.setSourceCSS("srcLineHilight");
                thisLine.setTestHitCSS(hitClass);
            } else if (hilightInfo) {
                thisLine.setLineNumberCSS("lineCount Good");
                thisLine.setCoverageCountCSS("coverageCount Good");
                thisLine.setSourceCSS("srcLine");
                thisLine.setTestHitCSS(hitClass);
            } else {
                thisLine.setLineNumberCSS("lineCount NoHilight");
                thisLine.setCoverageCountCSS("coverageCount NoHilight");
                thisLine.setSourceCSS("srcLine");
            }
            if (this.outOfDate) {
                thisLine.setLineNumberCSS("lineWarning");
            }
            thisLine.setHilight(hilightInfo && filteredCtx == null);
            thisLine.setCoverageStr(ccstr);
            thisLine.setMsg(msg);
            thisLine.setTestHits(testsForLine != null ? testsForLine : Collections.emptyList());
        }
        this.outOfDate = csr.getChecksum() != finfo.getChecksum();
        return renderedLines.toArray(new LineRenderInfo[renderedLines.size()]);
    }

    private String[] calcCoverageMsg(FullElementInfo lineElement, String emptyCoverageChar) {
        if (lineElement instanceof BranchInfo && !((BranchInfo)((Object)lineElement)).isInstrumented()) {
            return new String[]{SourceRenderHelper.getRegionStartStr(lineElement) + "coverage not measured due to assignment in expression.", "?"};
        }
        return new String[]{lineElement.getConstruct().calcCoverageMsg(lineElement, lineElement.getHitCount(), lineElement instanceof BranchInfo ? ((BranchInfo)((Object)lineElement)).getFalseHitCount() : 0, Locale.US), emptyCoverageChar};
    }

    private boolean noHits(ElementInfo lineElement) {
        return lineElement instanceof BranchInfo ? ((BranchInfo)lineElement).getTrueHitCount() == 0 || ((BranchInfo)lineElement).getFalseHitCount() == 0 : lineElement.getHitCount() == 0;
    }

    private int hitCounts(ElementInfo lineElement) {
        if (lineElement instanceof BranchInfo) {
            int tc = ((BranchInfo)lineElement).getTrueHitCount();
            int fc = ((BranchInfo)lineElement).getFalseHitCount();
            int hits = tc == Integer.MAX_VALUE || fc == Integer.MAX_VALUE ? Integer.MAX_VALUE : tc + fc;
            return hits < 0 ? Integer.MAX_VALUE : hits;
        }
        return lineElement.getHitCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChecksummingReader render(FullFileInfo finfo, List<LineRenderInfo> renderedLines, String emptyCoverageMsg, SourceRenderer renderer) throws Exception {
        Logger.getInstance().debug("Rendering " + finfo.getName() + " with renderer " + renderer.getClass().getName());
        ChecksummingReader csr = SourceRenderHelper.getChecksummingReader(finfo);
        try {
            renderer.render(renderedLines, csr, finfo, this.renderingHelper, emptyCoverageMsg, this.tabStr, this.spaceChar);
        }
        finally {
            csr.close();
        }
        return csr;
    }

    private String extensionOf(String path) {
        return path.substring(Math.max(0, path.lastIndexOf(46)), path.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSrcLines(FullFileInfo finfo) throws IOException {
        ArrayList<String> arrayList;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(finfo.getSourceReader());
            ArrayList<String> srclines = Lists.newArrayList();
            while ((line = reader.readLine()) != null) {
                srclines.add(line);
            }
            arrayList = srclines;
        }
        catch (Throwable throwable) {
            IOStreamUtils.close(reader);
            throw throwable;
        }
        IOStreamUtils.close(reader);
        return arrayList;
    }

    private static ChecksummingReader getChecksummingReader(FullFileInfo finfo) throws FileNotFoundException, UnsupportedEncodingException {
        return new ChecksummingReader(finfo.getSourceReader());
    }

    public static String getRegionStartStr(SourceInfo region) {
        return String.format("Line %d, Col %d: ", region.getStartLine(), region.getStartColumn());
    }
}

