/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html.source.groovy;

import clover.antlr.TokenStream;
import clover.org.codehaus.groovy.antlr.GroovySourceToken;
import clover.org.codehaus.groovy.antlr.parser.GroovyLexer;
import com.atlassian.clover.Logger;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.reporters.html.source.SourceListener;
import com.atlassian.clover.reporters.html.source.SourceRenderHelper;
import com.atlassian.clover.reporters.html.source.SourceTraverser;
import com.atlassian.clover.reporters.html.source.groovy.GroovySourceListener;
import com.atlassian.clover.reporters.html.source.java.JavaSourceListener;
import com.atlassian.clover.reporters.html.source.java.JavaTokenTraverser;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GroovySourceTraverser
implements SourceTraverser {
    static List<Integer> KEYWORDS = Arrays.asList(37, 38, 78, 79, 80, 81, 89, 90, 91, 94, 95, 100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115, 116, 117, 118, 125, 126, 127, 128, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 145, 146, 147, 148, 152, 154, 155, 156);

    public void traverse(Reader reader, FullFileInfo fileInfo, SourceListener sourceListener) throws Exception {
        GroovySourceToken currToken;
        final GroovySourceListener listener = (GroovySourceListener)sourceListener;
        List<String> lines = SourceRenderHelper.getSrcLines(fileInfo);
        lines.add(" ");
        GroovyLexer lexer = new GroovyLexer(reader);
        lexer.setWhitespaceIncluded(true);
        TokenStream stream = lexer.plumb();
        GroovySourceToken prevToken = currToken = (GroovySourceToken)stream.nextToken();
        GroovySourceToken firstToken = currToken;
        StringBuffer accumName = new StringBuffer();
        boolean gatherPkgIdent = false;
        boolean gatherImportIdent = false;
        listener.onStartDocument();
        while (prevToken != null && 1 != prevToken.getType()) {
            if (currToken == null || currToken.getType() != prevToken.getType()) {
                String[] fragLines = this.getLinesFor(firstToken, prevToken, lines);
                if (85 == prevToken.getType()) {
                    if (fragLines[0].charAt(0) == '/') {
                        GroovySourceTraverser.splitNewlinesAnd(fragLines, listener, new Closure<String>(){

                            @Override
                            public void perform(String chunk) {
                                listener.onRegexp(chunk);
                            }
                        });
                    } else {
                        GroovySourceTraverser.splitNewlinesAnd(fragLines, listener, new Closure<String>(){

                            @Override
                            public void perform(String chunk) {
                                listener.onStringLiteral(chunk);
                            }
                        });
                    }
                } else if (193 == prevToken.getType() || 194 == prevToken.getType() || 48 == prevToken.getType()) {
                    GroovySourceTraverser.splitNewlinesAnd(fragLines, listener, new Closure<String>(){

                        @Override
                        public void perform(String chunk) {
                            listener.onStringLiteral(chunk);
                        }
                    });
                } else if (205 == prevToken.getType()) {
                    listener.onCommentChunk(fragLines[0]);
                } else if (206 == prevToken.getType()) {
                    JavaTokenTraverser.processComment(this.join("\n", fragLines), listener);
                } else if (201 == prevToken.getType()) {
                    int times = Math.max(0, prevToken.getLineLast() - firstToken.getLine());
                    for (int i = 0; i < times; ++i) {
                        listener.onNewLine();
                    }
                } else if (KEYWORDS.contains(prevToken.getType())) {
                    listener.onKeyword(fragLines[0]);
                    gatherPkgIdent = prevToken.getType() == 78;
                    gatherImportIdent = prevToken.getType() == 79;
                } else {
                    String fragment = this.join("\n", fragLines);
                    if (gatherPkgIdent || gatherImportIdent) {
                        if (124 == prevToken.getType() || 109 == prevToken.getType()) {
                            if (gatherImportIdent) {
                                listener.onImport(accumName.toString().replace("\\s", ""));
                            }
                            accumName = new StringBuffer();
                            gatherPkgIdent = false;
                            gatherImportIdent = false;
                            listener.onChunk(fragment);
                        } else if (87 == prevToken.getType()) {
                            accumName.append(fragment);
                            listener.onChunk(fragment);
                        } else if (84 == prevToken.getType()) {
                            accumName.append(fragment);
                            String nameWithoutWhitespace = accumName.toString().replace("\\s", "");
                            if (gatherPkgIdent) {
                                listener.onPackageSegment(nameWithoutWhitespace, fragment);
                            } else {
                                listener.onImportSegment(nameWithoutWhitespace, fragment);
                            }
                        } else {
                            listener.onChunk(fragment);
                        }
                    } else if (84 == prevToken.getType()) {
                        listener.onIdentifier(fragment);
                    } else {
                        GroovySourceTraverser.splitNewlinesAnd(fragLines, listener, new Closure<String>(){

                            @Override
                            public void perform(String chunk) {
                                listener.onChunk(chunk);
                            }
                        });
                    }
                }
                firstToken = currToken;
            }
            prevToken = currToken;
            currToken = (GroovySourceToken)stream.nextToken();
        }
        listener.onEndDocument();
    }

    private String join(String joiner, String[] lines) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            buffer.append(lines[i]);
            if (i == lines.length - 1) continue;
            buffer.append(joiner);
        }
        return buffer.toString();
    }

    private static void splitNewlinesAnd(String[] lines, JavaSourceListener listener, Closure<String> c) {
        int lineCount = lines.length;
        for (int i = 0; i < lineCount; ++i) {
            c.perform(lines[i]);
            if (i >= lineCount - 1) continue;
            listener.onNewLine();
        }
    }

    private String[] getLinesFor(GroovySourceToken first, GroovySourceToken last, List<String> allLines) throws Exception {
        try {
            ArrayList<String> lines = new ArrayList<String>(allLines.subList(first.getLine() - 1, last.getLineLast()));
            String firstLine = (String)lines.get(0);
            if (lines.size() == 1) {
                lines.set(0, firstLine.substring(first.getColumn() - 1, last.getColumnLast() - 1));
            } else {
                String lastLine = (String)lines.get(lines.size() - 1);
                lines.set(0, firstLine.substring(first.getColumn() - 1, firstLine.length()));
                lines.set(lines.size() - 1, lastLine.substring(0, last.getColumnLast() - 1));
            }
            return lines.toArray(new String[lines.size()]);
        }
        catch (Exception e) {
            Logger.getInstance().verbose("Failed to grab lines for tokens", e);
            Logger.getInstance().debug("First token: " + first);
            Logger.getInstance().debug("Last token: " + last);
            Logger.getInstance().debug("Lines.size: " + allLines.size());
            throw e;
        }
    }

    private static interface Closure<T> {
        public void perform(T var1);
    }
}

