/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;

public class XMLWriter {
    private static final String NL = System.getProperty("line.separator");
    private static final String INDENT = "   ";
    private Writer out;
    private String encoding;
    private boolean pretty = true;
    private boolean inText = false;
    private int textLevel = -1;
    private int level = -1;
    private static final String AMP = "&";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String QUOT = "\"";
    private static final String APOS = "'";

    public XMLWriter(OutputStream os, String encoding) throws UnsupportedEncodingException {
        this.encoding = encoding;
        this.out = encoding == null ? new OutputStreamWriter(os) : new OutputStreamWriter(os, encoding);
    }

    public XMLWriter(Writer out) {
        this.out = out;
        if (out instanceof OutputStreamWriter) {
            this.encoding = ((OutputStreamWriter)out).getEncoding();
        }
    }

    public static String escapeAttributeValue(String str) {
        return str.replaceAll(AMP, "&amp;").replaceAll(LT, "&lt;").replaceAll(GT, "&gt;").replaceAll(QUOT, "&quot;").replaceAll(APOS, "&apos;");
    }

    public void writeXMLDecl() throws IOException {
        this.out.write("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.out.write(" encoding=\"" + this.encoding + QUOT);
        }
        this.out.write("?>");
    }

    public void writeElementStart(String name, Map<String, String> attribs) throws IOException {
        this.writeElementStart(name, attribs, false);
    }

    public void writeElement(String name, Map<String, String> attribs) throws IOException {
        this.writeElementStart(name, attribs, true);
    }

    public void writeElementStart(String name, Map<String, String> attribs, boolean atomic) throws IOException {
        ++this.level;
        if (this.pretty && !this.inText) {
            this.out.write(NL);
            this.writeIndent();
        }
        this.out.write(LT + name);
        for (String key : attribs.keySet()) {
            String val = attribs.get(key);
            this.out.write(" " + key + "=\"" + val + QUOT);
        }
        if (atomic) {
            --this.level;
            this.out.write("/");
        }
        this.out.write(GT);
    }

    public void writeElementEnd(String name) throws IOException {
        if (this.inText) {
            if (this.level == this.textLevel) {
                this.inText = false;
                this.textLevel = -1;
            }
        } else if (this.pretty) {
            this.out.write(NL);
            this.writeIndent();
        }
        --this.level;
        this.out.write("</" + name + GT);
    }

    public void writeText(String text) throws IOException {
        this.out.write(text);
        this.inText = true;
        if (this.textLevel == -1) {
            this.textLevel = this.level;
        }
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
    }

    private void writeIndent() throws IOException {
        for (int i = 0; i < this.level; ++i) {
            this.out.write(INDENT);
        }
    }
}

