/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.spi.lang;

import clover.com.google.common.collect.Sets;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public interface Language {
    public String getName();

    public Set<String> getFileExtensions();

    public Set<LanguageConstruct> getSupportedConstructs();

    public static enum Builtin implements Language
    {
        JAVA(".java", LanguageConstruct.Builtin.METHOD, LanguageConstruct.Builtin.BRANCH, LanguageConstruct.Builtin.STATEMENT),
        GROOVY(".groovy", LanguageConstruct.Builtin.METHOD, LanguageConstruct.Builtin.BRANCH, LanguageConstruct.Builtin.STATEMENT, LanguageConstruct.Builtin.GROOVY_FIELD_EXPRESSION, LanguageConstruct.Builtin.GROOVY_SAFE_METHOD, LanguageConstruct.Builtin.GROOVY_SAFE_ATTRIBUTE, LanguageConstruct.Builtin.GROOVY_SAFE_PROPERTY);

        private final Set<String> extensions;
        private final Set<LanguageConstruct> constructs;

        private Builtin(String extension, LanguageConstruct ... constructs) {
            this.extensions = Collections.singleton(extension);
            this.constructs = Collections.unmodifiableSet(Sets.newHashSet(constructs));
        }

        @Override
        public String getName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public Set<String> getFileExtensions() {
            return this.extensions;
        }

        @Override
        public Set<LanguageConstruct> getSupportedConstructs() {
            return this.constructs;
        }
    }
}

