/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import com.atlassian.clover.Logger;
import com.atlassian.clover.util.FOSFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class IOStreamUtils {
    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                Logger.getInstance().verbose("Failed to close resource: " + closeable, e);
            }
        }
    }

    public static OutputStream createDeflateOutputStream(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new DeflaterOutputStream((OutputStream)FOSFactory.newFOS(file), new Deflater(1), 8192));
    }

    public static InputStream createInflaterInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new InflaterInputStream(new BufferedInputStream(new FileInputStream(file))));
    }

    public static void writeChars(String str, DataOutputStream out) throws IOException {
        str = str == null ? "" : str;
        out.writeInt(str.length());
        out.writeChars(str);
    }
}

