/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util.trie;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixTree<K, V> {
    @NotNull
    protected Node<K, V> rootNode;
    protected final NodeFactory nodeFactory;

    public PrefixTree(@NotNull NodeFactory nodeFactory, @NotNull K key, @Nullable V value) {
        this.nodeFactory = nodeFactory;
        this.rootNode = nodeFactory.createNode(key, value);
    }

    public PrefixTree(@NotNull NodeFactory nodeFactory, @NotNull Node<K, V> rootNode) {
        this.nodeFactory = nodeFactory;
        this.rootNode = rootNode;
    }

    public void add(@NotNull KeySequence<K> keySequence, @Nullable V value) {
        Node<K, Object> currentNode = this.rootNode;
        for (K token : keySequence) {
            Node<K, Object> nextNode = currentNode.getChild(token);
            if (nextNode == null) {
                nextNode = currentNode.addChild(this.nodeFactory.createNode(token, null));
            }
            currentNode = nextNode;
        }
        currentNode.setValue(value);
    }

    @Nullable
    public Node<K, V> find(@NotNull KeySequence<K> keySequence) {
        Node<K, V> current = this.rootNode;
        for (K token : keySequence) {
            if ((current = current.getChild(token)) != null) continue;
            return null;
        }
        return current;
    }

    @NotNull
    public Node<K, V> findNearest(@NotNull KeySequence<K> keySequence) {
        Node<K, V> current = this.rootNode;
        for (K token : keySequence) {
            Node<K, V> next = current.getChild(token);
            if (next == null) {
                return current;
            }
            current = next;
        }
        return current;
    }

    @Nullable
    public Node<K, V> findNearestWithValue(@NotNull KeySequence<K> keySequence) {
        K token;
        Node<K, V> next;
        Node<K, V> current = this.rootNode;
        Node<K, V> lastWithValue = this.rootNode.getValue() != null ? this.rootNode : null;
        Iterator<K> i$ = keySequence.iterator();
        while (i$.hasNext() && (next = current.getChild(token = i$.next())) != null) {
            current = next;
            if (current.getValue() == null) continue;
            lastWithValue = current;
        }
        return lastWithValue;
    }

    @NotNull
    public Node<K, V> getRootNode() {
        return this.rootNode;
    }

    public void printTree() {
        this.printTree(System.out, this.rootNode);
    }

    void printTree(final @NotNull PrintStream out, @NotNull Node<K, V> rootNode) {
        NodeVisitor nodePrinter = new NodeVisitor<K, V>(){

            @Override
            public Node<K, V> visit(@NotNull Node<K, V> node, int depth) {
                StringBuilder line = new StringBuilder();
                for (int i = 0; i < depth; ++i) {
                    line.append("  ");
                }
                line.append('+');
                line.append(node.getKey().toString());
                if (node.getValue() != null) {
                    line.append(" (").append(node.getValue().toString()).append(')');
                }
                out.println(line);
                return node;
            }
        };
        this.walkTree(rootNode, nodePrinter);
    }

    public void walkTree(@NotNull Node<K, V> rootNode, @NotNull NodeVisitor<K, V> call) {
        this.walkTree(rootNode, 0, call);
    }

    protected void walkTree(@NotNull Node<K, V> node, int depth, @NotNull NodeVisitor<K, V> call) {
        call.visit(node, depth);
        for (Map.Entry<K, Node<K, V>> entry : node.children().entrySet()) {
            this.walkTree(entry.getValue(), depth + 1, call);
        }
    }

    public Node<K, V> rewriteTree(@NotNull Node<K, V> rootNode, @NotNull NodeVisitor<K, V> call) {
        return this.rewriteTree(rootNode, 0, call);
    }

    protected Node<K, V> rewriteTree(@NotNull Node<K, V> node, int depth, @NotNull NodeVisitor<K, V> call) {
        Map<K, Node<K, V>> oldChildren = this.nodeFactory.cloneChildren(node);
        node.children().clear();
        for (Map.Entry<K, Node<K, V>> entry : oldChildren.entrySet()) {
            node.addChild(this.rewriteTree(entry.getValue(), depth + 1, call));
        }
        return call.visit(node, depth);
    }

    public static interface NodeVisitor<K, V> {
        public Node<K, V> visit(@NotNull Node<K, V> var1, int var2);
    }

    public static interface NodeFactory {
        public <K, V> Node<K, V> createNode(@NotNull K var1, @Nullable V var2);

        public <K, V> Map<K, Node<K, V>> cloneChildren(@NotNull Node<K, V> var1);
    }

    public static class KeySequence<K>
    implements Iterable<K> {
        private final List<K> subKeys;

        public KeySequence() {
            this.subKeys = Collections.emptyList();
        }

        public KeySequence(List<K> subKeys) {
            this.subKeys = subKeys;
        }

        @Override
        public Iterator<K> iterator() {
            return this.subKeys.iterator();
        }
    }

    public static interface Node<K, V> {
        @Nullable
        public V getValue();

        @NotNull
        public K getKey();

        @Nullable
        public Node<K, V> getChild(K var1);

        @NotNull
        public Node<K, V> addChild(@NotNull Node<K, V> var1);

        public void setValue(@Nullable V var1);

        @NotNull
        public Map<K, Node<K, V>> children();
    }
}

