/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.appsforyourdomain.audit;

import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class MailMonitor {
    private String requestId;
    private String destUserName;
    private Date beginDate;
    private Date endDate;
    private String incomingEmailMonitorLevel;
    private String outgoingEmailMonitorLevel;
    private String draftMonitorLevel;
    private String chatMonitorLevel;
    private static DateFormat DATE_FORMAT = null;

    public MailMonitor() {
    }

    public MailMonitor(GenericEntry entry) {
        this.requestId = entry.getProperty("requestId");
        this.destUserName = entry.getProperty("destUserName");
        this.beginDate = DATE_FORMAT.parse(entry.getProperty("beginDate"), new ParsePosition(0));
        this.endDate = DATE_FORMAT.parse(entry.getProperty("endDate"), new ParsePosition(0));
        this.incomingEmailMonitorLevel = entry.getProperty("incomingEmailMonitorLevel");
        this.outgoingEmailMonitorLevel = entry.getProperty("outgoingEmailMonitorLevel");
        this.draftMonitorLevel = entry.getProperty("draftMonitorLevel");
        this.chatMonitorLevel = entry.getProperty("chatMonitorLevel");
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getDestUserName() {
        return this.destUserName;
    }

    public void setDestUserName(String destUserName) {
        this.destUserName = destUserName;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getIncomingEmailMonitorLevel() {
        return this.incomingEmailMonitorLevel;
    }

    public void setIncomingEmailMonitorLevel(String incomingEmailMonitorLevel) {
        this.incomingEmailMonitorLevel = incomingEmailMonitorLevel;
    }

    public String getOutgoingEmailMonitorLevel() {
        return this.outgoingEmailMonitorLevel;
    }

    public void setOutgoingEmailMonitorLevel(String outgoingEmailMonitorLevel) {
        this.outgoingEmailMonitorLevel = outgoingEmailMonitorLevel;
    }

    public String getDraftMonitorLevel() {
        return this.draftMonitorLevel;
    }

    public void setDraftMonitorLevel(String draftMonitorLevel) {
        this.draftMonitorLevel = draftMonitorLevel;
    }

    public String getChatMonitorLevel() {
        return this.chatMonitorLevel;
    }

    public void setChatMonitorLevel(String chatMonitorLevel) {
        this.chatMonitorLevel = chatMonitorLevel;
    }

    public GenericEntry toGenericEntry() {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("destUserName", this.destUserName);
        entry.addProperty("beginDate", DATE_FORMAT.format(this.beginDate));
        entry.addProperty("endDate", DATE_FORMAT.format(this.endDate));
        entry.addProperty("incomingEmailMonitorLevel", this.incomingEmailMonitorLevel);
        entry.addProperty("outgoingEmailMonitorLevel", this.outgoingEmailMonitorLevel);
        entry.addProperty("draftMonitorLevel", this.draftMonitorLevel);
        entry.addProperty("chatMonitorLevel", this.chatMonitorLevel);
        return entry;
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        DATE_FORMAT.setLenient(false);
    }
}

