/*
 * Decompiled with CFR 0.152.
 */
package eu.infomas.annotation;

import eu.infomas.annotation.FileIterator;
import eu.infomas.annotation.ZipFileIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;

final class ClassFileIterator {
    private final FileIterator fileIterator;
    private final String[] pkgNameFilter;
    private ZipFileIterator zipIterator;
    private boolean isFile;

    ClassFileIterator() throws IOException {
        this(ClassFileIterator.classPath(), null);
    }

    ClassFileIterator(File[] fileArray, String[] stringArray) throws IOException {
        this.fileIterator = new FileIterator(fileArray);
        this.pkgNameFilter = stringArray;
    }

    public String getName() {
        return this.zipIterator == null ? this.fileIterator.getFile().getPath() : this.zipIterator.getEntry().getName();
    }

    public boolean isFile() {
        return this.isFile;
    }

    public InputStream next() throws IOException {
        Object object;
        while (true) {
            if (this.zipIterator == null) {
                object = this.fileIterator.next();
                if (object == null) {
                    return null;
                }
                String string = ((File)object).getName();
                if (string.endsWith(".class")) {
                    this.isFile = true;
                    return new FileInputStream((File)object);
                }
                if (!this.fileIterator.isRootFile() || !ClassFileIterator.endsWithIgnoreCase(string, ".jar")) continue;
                this.zipIterator = new ZipFileIterator(new ZipFile((File)object), this.pkgNameFilter);
                continue;
            }
            object = this.zipIterator.next();
            if (object != null) break;
            this.zipIterator = null;
        }
        this.isFile = false;
        return object;
    }

    private static File[] classPath() {
        String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        return fileArray;
    }

    private static boolean endsWithIgnoreCase(String string, String string2) {
        int n = string2.length();
        return string.regionMatches(true, string.length() - n, string2, 0, n);
    }
}

