/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.ComparatorFactory;
import org.assertj.core.data.Index;
import org.assertj.core.data.Offset;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.FloatArrays;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractFloatArrayAssert<S extends AbstractFloatArrayAssert<S>>
extends AbstractArrayAssert<S, float[], Float> {
    @VisibleForTesting
    protected FloatArrays arrays = FloatArrays.instance();
    private final ComparatorFactory floatComparator = ComparatorFactory.INSTANCE;

    public AbstractFloatArrayAssert(float[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (float[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (float[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (float[])this.actual);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (float[])this.actual, expected);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (float[])this.actual, other);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S contains(float ... values) {
        this.arrays.assertContains(this.info, (float[])this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S contains(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.contains(values);
    }

    public S containsOnly(float ... values) {
        this.arrays.assertContainsOnly(this.info, (float[])this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S containsOnly(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.containsOnly(values);
    }

    public S containsOnlyOnce(float ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (float[])this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S containsOnlyOnce(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.containsOnlyOnce(values);
    }

    public S containsSequence(float ... sequence) {
        this.arrays.assertContainsSequence(this.info, (float[])this.actual, sequence);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S containsSequence(float[] sequence, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.containsSequence(sequence);
    }

    public S containsSubsequence(float ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (float[])this.actual, subsequence);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S containsSubsequence(float[] subsequence, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.containsSubsequence(subsequence);
    }

    public S contains(float value, Index index) {
        this.arrays.assertContains(this.info, (float[])this.actual, value, index);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S contains(float value, Index index, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.contains(value, index);
    }

    public S doesNotContain(float ... values) {
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S doesNotContain(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S doesNotContain(float value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (float[])this.actual, value, index);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S doesNotContain(float value, Index index, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.doesNotContain(value, index);
    }

    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (float[])this.actual);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S doesNotHaveDuplicates(Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.doesNotHaveDuplicates();
    }

    public S startsWith(float ... sequence) {
        this.arrays.assertStartsWith(this.info, (float[])this.actual, sequence);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S startsWith(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.startsWith(values);
    }

    public S endsWith(float ... sequence) {
        this.arrays.assertEndsWith(this.info, (float[])this.actual, sequence);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S endsWith(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.endsWith(values);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (float[])this.actual);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super Float> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (float[])this.actual, comparator);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super Float> customComparator) {
        this.arrays = new FloatArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.arrays = FloatArrays.instance();
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S containsExactly(float ... values) {
        this.arrays.assertContainsExactly(this.info, (float[])this.actual, values);
        return (S)((AbstractFloatArrayAssert)this.myself);
    }

    public S containsExactly(float[] values, Offset<Float> precision) {
        this.usingComparatorWithPrecision((Float)precision.value);
        return this.containsExactly(values);
    }

    public S usingComparatorWithPrecision(Float precision) {
        return (S)this.usingElementComparator(this.floatComparator.floatComparatorWithPrecision(precision.floatValue()));
    }
}

