/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ActivityState;
import org.datanucleus.state.JDOStateManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ReferentialJDOStateManager
extends JDOStateManager {
    private List<ReferentialJDOStateManager> insertionNotifyList = null;
    private Map<ReferentialJDOStateManager, FieldContainer> fieldsToBeUpdatedAfterObjectInsertion = null;

    public ReferentialJDOStateManager(ExecutionContext ec, AbstractClassMetaData cmd) {
        super(ec, cmd);
    }

    public void connect(ExecutionContext ec, AbstractClassMetaData cmd) {
        super.connect(ec, cmd);
        this.fieldsToBeUpdatedAfterObjectInsertion = null;
        this.insertionNotifyList = null;
    }

    public void disconnect() {
        this.fieldsToBeUpdatedAfterObjectInsertion = null;
        this.insertionNotifyList = null;
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeActivityState(ActivityState activityState) {
        this.activity = activityState;
        if (activityState == ActivityState.INSERTING_CALLBACKS && this.insertionNotifyList != null) {
            List<ReferentialJDOStateManager> list = this.insertionNotifyList;
            synchronized (list) {
                for (ReferentialJDOStateManager notifySM : this.insertionNotifyList) {
                    notifySM.insertionCompleted(this);
                }
            }
            this.insertionNotifyList.clear();
            this.insertionNotifyList = null;
        }
    }

    public void updateFieldAfterInsert(Object pc, int fieldNumber) {
        FieldContainer cont;
        ReferentialJDOStateManager otherSM = (ReferentialJDOStateManager)this.myEC.findObjectProvider(pc);
        if (otherSM.insertionNotifyList == null) {
            otherSM.insertionNotifyList = Collections.synchronizedList(new ArrayList(1));
        }
        otherSM.insertionNotifyList.add(this);
        if (this.fieldsToBeUpdatedAfterObjectInsertion == null) {
            this.fieldsToBeUpdatedAfterObjectInsertion = new HashMap<ReferentialJDOStateManager, FieldContainer>(1);
        }
        if ((cont = this.fieldsToBeUpdatedAfterObjectInsertion.get(otherSM)) == null) {
            cont = new FieldContainer(fieldNumber);
        } else {
            cont.set(fieldNumber);
        }
        this.fieldsToBeUpdatedAfterObjectInsertion.put(otherSM, cont);
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026021", (Object)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getFullFieldName(), (Object)StringUtils.toJVMIDString(this.myPC), (Object)StringUtils.toJVMIDString(pc)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertionCompleted(ReferentialJDOStateManager op) {
        if (this.fieldsToBeUpdatedAfterObjectInsertion == null) {
            return;
        }
        FieldContainer fldCont = this.fieldsToBeUpdatedAfterObjectInsertion.get(op);
        if (fldCont != null) {
            this.dirty = true;
            int[] fieldsToUpdate = fldCont.getFields();
            for (int i = 0; i < fieldsToUpdate.length; ++i) {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("026022", (Object)this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldsToUpdate[i]).getFullFieldName(), (Object)IdentityUtils.getIdentityAsString(this.myEC.getApiAdapter(), this.myID), (Object)StringUtils.toJVMIDString(op.getObject())));
                }
                this.dirtyFields[fieldsToUpdate[i]] = true;
            }
            this.fieldsToBeUpdatedAfterObjectInsertion.remove(op);
            if (this.fieldsToBeUpdatedAfterObjectInsertion.isEmpty()) {
                this.fieldsToBeUpdatedAfterObjectInsertion = null;
            }
            try {
                this.flags |= 0x4000;
                this.flush();
                Object var6_5 = null;
                this.flags &= 0xFFFFBFFF;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.flags &= 0xFFFFBFFF;
                throw throwable;
            }
        }
    }

    private class FieldContainer {
        boolean[] fieldsToUpdate;

        public FieldContainer(int fieldNumber) {
            this.fieldsToUpdate = new boolean[ReferentialJDOStateManager.this.cmd.getAllMemberPositions().length];
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public void set(int fieldNumber) {
            this.fieldsToUpdate[fieldNumber] = true;
        }

        public int[] getFields() {
            return ClassUtils.getFlagsSetTo(this.fieldsToUpdate, true);
        }
    }
}

