/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.MessageHandlerManager;
import org.glassfish.tyrus.core.PrimitivesToWrappers;

class AnnotatedClassValidityChecker {
    private static final String MULTIPLE_IDENTICAL_PARAMETERS = " has got multiple parameters of identical type.";
    private static final String FORBIDDEN_WEB_SOCKET_OPEN_PARAM = " is not allowed as parameter type for method annotated with @OnOpen.";
    private static final String FORBIDDEN_WEB_SOCKET_CLOSE_PARAMS = " @OnClose has got different params than Session or CloseReason.";
    private static final String FORBIDDEN_WEB_SOCKET_ERROR_PARAM = " is not allowed as parameter type for method annotated with @OnError.";
    private static final String MANDATORY_ERROR_PARAM_MISSING = " does not have mandatory Throwable param.";
    private static final String FORBIDDEN_RETURN_TYPE = " has got unsupported return type.";
    private final Class<?> annotatedClass;
    private final List<Class<? extends Encoder>> encoders;
    private final ErrorCollector collector;
    private final MessageHandlerManager handlerManager;

    public AnnotatedClassValidityChecker(Class<?> annotatedClass, List<Class<? extends Encoder>> encoders, List<Class<? extends Decoder>> decoders, ErrorCollector collector) {
        this.annotatedClass = annotatedClass;
        this.encoders = encoders;
        this.collector = collector;
        this.handlerManager = new MessageHandlerManager(decoders);
    }

    public void checkOnMessageParams(Method method, MessageHandler handler) throws DeploymentException {
        try {
            this.handlerManager.addMessageHandler(handler);
        }
        catch (IllegalStateException ise) {
            this.collector.addException((Exception)new DeploymentException(ise.getMessage(), ise.getCause()));
        }
        this.checkOnMessageReturnType(method);
    }

    private void checkOnMessageReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (!(returnType == Void.TYPE || returnType == String.class || returnType == ByteBuffer.class || returnType == byte[].class || returnType.isPrimitive() || this.checkEncoders(returnType) || PrimitivesToWrappers.isPrimitiveWrapper(returnType))) {
            this.logDeploymentException(new DeploymentException(String.format("Method: %s.%s %s", this.annotatedClass.getName(), method.getName(), FORBIDDEN_RETURN_TYPE)));
        }
    }

    public void checkOnOpenParams(Method method, Map<Integer, Class<?>> params) {
        for (Class<?> value : params.values()) {
            if (value == EndpointConfig.class) continue;
            this.logDeploymentException(new DeploymentException(String.format("%s:%s %s", this.getPrefix(method.getName()), value, FORBIDDEN_WEB_SOCKET_OPEN_PARAM)));
        }
    }

    public void checkOnCloseParams(Method method, Map<Integer, Class<?>> params) {
        for (Class<?> value : params.values()) {
            if (value == CloseReason.class) continue;
            this.logDeploymentException(new DeploymentException(String.format("%s %s", this.getPrefix(method.getName()), FORBIDDEN_WEB_SOCKET_CLOSE_PARAMS)));
        }
    }

    public void checkOnErrorParams(Method method, Map<Integer, Class<?>> params) {
        boolean throwablePresent = false;
        for (Class<?> value : params.values()) {
            if (value != Throwable.class) {
                this.logDeploymentException(new DeploymentException(String.format("%s%s%s", this.getPrefix(method.getName()), value, FORBIDDEN_WEB_SOCKET_ERROR_PARAM)));
                continue;
            }
            if (throwablePresent) {
                this.logDeploymentException(new DeploymentException(String.format("%s%s", this.getPrefix(method.getName()), MULTIPLE_IDENTICAL_PARAMETERS)));
            }
            throwablePresent = true;
        }
        if (!throwablePresent) {
            this.logDeploymentException(new DeploymentException(String.format("%s%s", this.getPrefix(method.getName()), MANDATORY_ERROR_PARAM_MISSING)));
        }
    }

    private String getPrefix(String methodName) {
        return String.format("Method:  %s.%s:", this.annotatedClass.getName(), methodName);
    }

    private boolean checkEncoders(Class<?> requiredType) {
        for (Class<? extends Encoder> encoderClass : this.encoders) {
            if (!AnnotatedEndpoint.getEncoderClassType(encoderClass).isAssignableFrom(requiredType)) continue;
            return true;
        }
        return false;
    }

    private void logDeploymentException(DeploymentException de) {
        this.collector.addException((Exception)de);
    }
}

