/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.impl.VirtualFileBoundJavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.VirtualFileKotlinClass;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleResolver", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "diagnosticFor", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "targetClassOrPackage", "Lorg/jetbrains/kotlin/descriptors/ClassOrPackageFragmentDescriptor;", "originalDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithSource;", "fileFromOurModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFile", "descriptor", "ClassifierUsage", "frontend.java"})
public final class JvmModuleAccessibilityChecker
implements CallChecker {
    private final JavaModuleResolver moduleResolver;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        block2: {
            Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Object descriptor2 = resolvedCall2.getResultingDescriptor();
            if (descriptor2 instanceof ClassConstructorDescriptor) {
                return;
            }
            ClassOrPackageFragmentDescriptor classOrPackageFragmentDescriptor = DescriptorUtils.getParentOfType((DeclarationDescriptor)descriptor2, ClassOrPackageFragmentDescriptor.class);
            if (classOrPackageFragmentDescriptor == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)classOrPackageFragmentDescriptor, (String)"DescriptorUtils.getParen\u2026or::class.java) ?: return");
            ClassOrPackageFragmentDescriptor targetDescriptor = classOrPackageFragmentDescriptor;
            KtFile ktFile = DescriptorToSourceUtils.getContainingFile(context2.getScope().getOwnerDescriptor());
            VirtualFile fileFromOurModule = ktFile != null ? ktFile.getVirtualFile() : null;
            Diagnostic diagnostic = this.diagnosticFor(targetDescriptor, (DeclarationDescriptorWithSource)descriptor2, fileFromOurModule, reportOn);
            if (diagnostic == null) break block2;
            Diagnostic diagnostic2 = diagnostic;
            BindingTrace bindingTrace = context2.getTrace();
            boolean bl = false;
            boolean bl2 = false;
            Diagnostic p1 = diagnostic2;
            boolean bl3 = false;
            bindingTrace.report(p1);
        }
    }

    private final Diagnostic diagnosticFor(ClassOrPackageFragmentDescriptor targetClassOrPackage, DeclarationDescriptorWithSource originalDescriptor, VirtualFile fileFromOurModule, PsiElement reportOn) {
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic;
        JavaModuleResolver.AccessError diagnostic;
        Object object;
        VirtualFile virtualFile2 = this.findVirtualFile(targetClassOrPackage, originalDescriptor);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile referencedFile = virtualFile2;
        DeclarationDescriptorWithSource declarationDescriptorWithSource = originalDescriptor;
        if (!(declarationDescriptorWithSource instanceof DeserializedMemberDescriptor)) {
            declarationDescriptorWithSource = null;
        }
        if ((object = (DeserializedMemberDescriptor)declarationDescriptorWithSource) == null || (object = UtilKt.getImplClassNameForDeserialized((DescriptorWithContainerSource)object)) == null || (object = ((JvmClassName)object).getPackageFqName()) == null) {
            PackageFragmentDescriptor packageFragmentDescriptor = DescriptorUtils.getParentOfType(targetClassOrPackage, PackageFragmentDescriptor.class, false);
            object = packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null;
        }
        Object referencedPackageFqName = object;
        JavaModuleResolver.AccessError accessError = diagnostic = this.moduleResolver.checkAccessibility(fileFromOurModule, referencedFile, (FqName)referencedPackageFqName);
        if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule) {
            parametrizedDiagnostic = (ParametrizedDiagnostic<PsiElement>)ErrorsJvm.JAVA_MODULE_DOES_NOT_READ_UNNAMED_MODULE.on(reportOn);
        } else if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotReadModule) {
            parametrizedDiagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE.on(reportOn, ((JavaModuleResolver.AccessError.ModuleDoesNotReadModule)diagnostic).getDependencyModuleName());
        } else if (accessError instanceof JavaModuleResolver.AccessError.ModuleDoesNotExportPackage) {
            String string = ((JavaModuleResolver.AccessError.ModuleDoesNotExportPackage)diagnostic).getDependencyModuleName();
            Object object2 = referencedPackageFqName;
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            parametrizedDiagnostic = ErrorsJvm.JAVA_MODULE_DOES_NOT_EXPORT_PACKAGE.on(reportOn, string, ((FqName)object2).asString());
        } else {
            parametrizedDiagnostic = null;
        }
        return parametrizedDiagnostic;
    }

    private final VirtualFile findVirtualFile(ClassOrPackageFragmentDescriptor descriptor2, DeclarationDescriptorWithSource originalDescriptor) {
        UserDataHolder userDataHolder;
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
        SourceElement source = sourceElement;
        Object object = source;
        if (object instanceof KotlinJvmBinarySourceElement) {
            Object object2;
            KotlinJvmBinaryClass kotlinJvmBinaryClass2 = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            if (!(kotlinJvmBinaryClass2 instanceof VirtualFileKotlinClass)) {
                kotlinJvmBinaryClass2 = null;
            }
            if ((object2 = (VirtualFileKotlinClass)kotlinJvmBinaryClass2) != null && (object2 = ((VirtualFileKotlinClass)object2).getFile()) != null) {
                Object object3 = object2;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object3;
                boolean bl3 = false;
                return it;
            }
        } else if (object instanceof JavaSourceElement) {
            Object object4;
            JavaElement javaElement = ((JavaSourceElement)source).getJavaElement();
            if (!(javaElement instanceof VirtualFileBoundJavaClass)) {
                javaElement = null;
            }
            if ((object4 = (VirtualFileBoundJavaClass)javaElement) != null && (object4 = object4.getVirtualFile()) != null) {
                Object object5 = object4;
                boolean bl = false;
                boolean bl4 = false;
                Object it = object5;
                boolean bl5 = false;
                return it;
            }
        } else if (object instanceof KotlinJvmBinaryPackageSourceElement && originalDescriptor instanceof DeserializedMemberDescriptor) {
            Object object6;
            KotlinJvmBinaryClass kotlinJvmBinaryClass3 = ((KotlinJvmBinaryPackageSourceElement)source).getContainingBinaryClass((DeserializedMemberDescriptor)originalDescriptor);
            if (!(kotlinJvmBinaryClass3 instanceof VirtualFileKotlinClass)) {
                kotlinJvmBinaryClass3 = null;
            }
            if ((object6 = (VirtualFileKotlinClass)kotlinJvmBinaryClass3) != null && (object6 = ((VirtualFileKotlinClass)object6).getFile()) != null) {
                Object object7 = object6;
                boolean bl = false;
                boolean bl6 = false;
                Object it = object7;
                boolean bl7 = false;
                return it;
            }
        }
        if ((userDataHolder = KotlinSourceElementKt.getPsi(source)) != null && (userDataHolder = userDataHolder.getContainingFile()) != null && (userDataHolder = userDataHolder.getVirtualFile()) != null) {
            object = userDataHolder;
            boolean bl = false;
            boolean bl8 = false;
            Object it = object;
            boolean bl9 = false;
            return it;
        }
        Object object8 = originalDescriptor;
        return object8 != null && (object8 = object8.getSource()) != null && (object8 = KotlinSourceElementKt.getPsi((SourceElement)object8)) != null && (object8 = object8.getContainingFile()) != null ? object8.getVirtualFile() : null;
    }

    public JvmModuleAccessibilityChecker(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.moduleResolver = JavaModuleResolver.SERVICE.getInstance(project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "(Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmModuleAccessibilityChecker;)V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend.java"})
    public final class ClassifierUsage
    implements ClassifierUsageChecker {
        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
            block6: {
                ClassDescriptor expandedClass;
                ClassifierDescriptor classifierDescriptor;
                boolean bl;
                Object object;
                ClassifierDescriptor classifierDescriptor2;
                VirtualFile virtualFile2;
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)targetDescriptor, (String)"targetDescriptor");
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                    PsiFile psiFile = element.getContainingFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
                    virtualFile2 = psiFile.getVirtualFile();
                    classifierDescriptor2 = targetDescriptor;
                    if (!(classifierDescriptor2 instanceof ClassDescriptor)) break block5;
                    Diagnostic diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor((ClassOrPackageFragmentDescriptor)((Object)targetDescriptor), targetDescriptor, virtualFile2, element);
                    if (diagnostic == null) break block6;
                    Diagnostic diagnostic2 = diagnostic;
                    BindingTrace bindingTrace = context2.getTrace();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Diagnostic p1 = diagnostic2;
                    boolean bl4 = false;
                    bindingTrace.report(p1);
                    break block6;
                }
                if (!(classifierDescriptor2 instanceof TypeAliasDescriptor)) break block6;
                ClassOrPackageFragmentDescriptor containingClassOrPackage = DescriptorUtils.getParentOfType(targetDescriptor, ClassOrPackageFragmentDescriptor.class);
                if (containingClassOrPackage != null) {
                    Diagnostic diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor(containingClassOrPackage, targetDescriptor, virtualFile2, element);
                    if (diagnostic != null) {
                        Diagnostic diagnostic3 = diagnostic;
                        object = context2.getTrace();
                        boolean bl5 = false;
                        bl = false;
                        Diagnostic p1 = diagnostic3;
                        boolean bl6 = false;
                        object.report(p1);
                    }
                }
                if (!((classifierDescriptor = ((TypeAliasDescriptor)targetDescriptor).getExpandedType().getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                if ((expandedClass = (ClassDescriptor)classifierDescriptor) != null) {
                    Diagnostic diagnostic = JvmModuleAccessibilityChecker.this.diagnosticFor(expandedClass, expandedClass, virtualFile2, element);
                    if (diagnostic != null) {
                        object = diagnostic;
                        BindingTrace bindingTrace = context2.getTrace();
                        bl = false;
                        boolean bl7 = false;
                        Object p1 = object;
                        boolean bl8 = false;
                        bindingTrace.report((Diagnostic)p1);
                    }
                }
            }
        }
    }
}

